/*
 * Decompiled with CFR 0.152.
 */
package datahike.java;

import clojure.java.api.Clojure;
import clojure.lang.APersistentMap;
import clojure.lang.APersistentVector;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentVector;
import datahike.java.Database;
import datahike.java.Datahike;
import datahike.java.IEntity;
import datahike.java.SchemaFlexibility;
import datahike.java.Util;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class DatahikeTest {
    private Object schema = Clojure.read((String)" [{:db/ident :name\n                 :db/valueType :db.type/string\n                 :db/unique :db.unique/identity\n                 :db/index true\n                 :db/cardinality :db.cardinality/one}\n                {:db/ident :age\n                 :db/valueType :db.type/long\n                 :db/cardinality :db.cardinality/one}]");
    private Date firstDate;
    private String query;

    private APersistentMap config() {
        UUID uUID = UUID.randomUUID();
        return Util.map(Util.kwd(":store"), Util.map(Util.kwd(":backend"), Util.kwd(":memory"), Util.kwd(":id"), uUID), Util.kwd(":initial-tx"), this.schema);
    }

    private Object transactOnce() {
        APersistentMap aPersistentMap = this.config();
        Datahike.createDatabase((Map<String, Object>)aPersistentMap);
        Object object = Datahike.connect((Map<String, Object>)aPersistentMap);
        this.query = "[:find ?n ?a :where [?e :name ?n] [?e :age ?a]]";
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":name"), "Alice", Util.kwd(":age"), 25L), Util.map(Util.kwd(":name"), "Bob", Util.kwd(":age"), 30L)));
        return object;
    }

    @Test
    public void databaseExists() {
        APersistentMap aPersistentMap = this.config();
        Datahike.createDatabase((Map<String, Object>)aPersistentMap);
        Assert.assertTrue((boolean)Datahike.databaseExists((Map<String, Object>)aPersistentMap));
        APersistentMap aPersistentMap2 = (APersistentMap)Util.ednFromString("{:store {:backend :memory :id #uuid \"00000000-0000-0000-0000-000000000000\"}}");
        Assert.assertFalse((boolean)Datahike.databaseExists((Map<String, Object>)aPersistentMap2));
    }

    @Test
    public void queryWithDBAndInput() {
        Object object = this.transactOnce();
        this.query = "[:find ?n ?a :in $ [?n] :where [?e :name ?n] [?e :age ?a]]";
        Set set = (Set)Datahike.q(this.query, Datahike.deref(object), Clojure.read((String)"[\"Alice\"]"));
        Object[] objectArray = set.stream().map(aPersistentVector -> aPersistentVector.get(0)).toArray();
        Assert.assertTrue((boolean)objectArray[0].equals("Alice"));
    }

    @Test
    public void queryWithJavaArrayInput() {
        Object object = this.transactOnce();
        this.query = "[:find ?n ?a :in $ [?n] :where [?e :name ?n] [?e :age ?a]]";
        Set set = (Set)Datahike.q(this.query, Datahike.deref(object), new String[]{"Alice"});
        Object[] objectArray = set.stream().map(aPersistentVector -> aPersistentVector.get(0)).toArray();
        Assert.assertTrue((boolean)objectArray[0].equals("Alice"));
    }

    @Test
    public void queryWithLocalInputDB() {
        Object object = Clojure.read((String)"[[1 :name 'Ivan'] [1 :age  19] [1 :aka  \"dragon_killer_94\"] [1 :aka  '-=autobot=-']]");
        Set set = (Set)Datahike.q("[:find  ?n ?a :where [?e :aka \"dragon_killer_94\"] [?e :name ?n] [?e :age  ?a]]", object);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void queryWithDB() {
        APersistentMap aPersistentMap = this.config();
        Datahike.createDatabase((Map<String, Object>)aPersistentMap);
        Object object = Datahike.connect((Map<String, Object>)aPersistentMap);
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":db/ident"), Util.kwd(":name"), Util.kwd(":db/valueType"), Util.kwd(":db.type/string"), Util.kwd(":db/cardinality"), Util.kwd(":db.cardinality/one"))));
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":name"), "Alice")));
        Object object2 = Datahike.deref(object);
        Set set = (Set)Datahike.q("[:find ?e :where [?e :name]]", object2);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
        set = (Set)Datahike.q("[:find ?v :where [_ :name ?v]]", object2);
        Assert.assertEquals((Object)PersistentHashSet.create(Arrays.asList(PersistentVector.create((Object[])new Object[]{"Alice"}))), (Object)set);
    }

    @Test
    public void history() {
        Object object = this.transactOnce();
        Set set = (Set)Datahike.q(this.query, Datahike.history(Datahike.deref(object)));
        Object[] objectArray = set.stream().map(aPersistentVector -> aPersistentVector.get(0)).toArray();
        Assert.assertArrayEquals((Object[])new String[]{"Alice", "Bob"}, (Object[])objectArray);
    }

    @Test
    public void asOfAndSince() {
        Object object = this.transactOnce();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.firstDate = new Date();
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":db/id"), Util.vec(Util.kwd(":name"), "Alice"), Util.kwd(":age"), 30L)));
        Set set = (Set)Datahike.q(this.query, Datahike.asOf(Datahike.deref(object), this.firstDate));
        Assert.assertEquals((long)2L, (long)set.size());
        set = (Set)Datahike.q(this.query, Datahike.since(Datahike.deref(object), this.firstDate));
        Assert.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void pullAndPullMany() {
        Object object = this.transactOnce();
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":db/id"), 10, Util.kwd(":name"), "Joe", Util.kwd(":age"), 50L)));
        Map<?, ?> map = Datahike.pull(Datahike.deref(object), "[*]", (Object)10);
        Assert.assertEquals((Object)"Joe", map.get(Util.kwd(":name")));
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":db/id"), 20, Util.kwd(":name"), "Jane", Util.kwd(":age"), 25L)));
        List<?> list = Datahike.pullMany(Datahike.deref(object), "[*]", Util.vec(10, 20));
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void release() {
        APersistentMap aPersistentMap = this.config();
        Datahike.createDatabase((Map<String, Object>)aPersistentMap);
        Object object = Datahike.connect((Map<String, Object>)aPersistentMap);
        Datahike.release(object);
    }

    @Test
    public void seekDatoms() {
        APersistentMap aPersistentMap = this.config();
        Datahike.createDatabase((Map<String, Object>)aPersistentMap);
        Object object = Datahike.connect((Map<String, Object>)aPersistentMap);
        Datahike.transact(object, (List)((APersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]")));
        Object object2 = Datahike.deref(object);
        Iterable<?> iterable = Datahike.seekdatoms(object2, Util.kwd(":eavt"), 10);
        Assert.assertNotNull(iterable);
        boolean bl = false;
        Iterator<?> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
    }

    @Test
    public void tempId() {
        Object object = Datahike.tempid(Util.kwd(":db.part/user"));
        Assert.assertTrue((((Number)object).longValue() < 0L ? 1 : 0) != 0);
        object = Datahike.tempid(Util.kwd(":db.part/user"), -10000);
        Assert.assertEquals((long)-10000L, (long)((Number)object).longValue());
    }

    @Test
    public void entity() {
        Object object = this.transactOnce();
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":db/id"), 10, Util.kwd(":name"), "Joe", Util.kwd(":age"), 50L)));
        IEntity iEntity = (IEntity)Datahike.entity(Datahike.deref(object), 10);
        Object object2 = iEntity.valAt(Util.kwd(":name"));
        Assert.assertEquals((Object)"Joe", (Object)object2);
    }

    @Test
    public void entityDb() {
        Object object = this.transactOnce();
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":db/id"), 10, Util.kwd(":name"), "Joe", Util.kwd(":age"), 50L)));
        IEntity iEntity = (IEntity)Datahike.entity(Datahike.deref(object), 10);
        Object object2 = Datahike.entityDb(iEntity);
        Assert.assertNotNull((Object)object2);
    }

    @Test
    public void filterAndIsFiltered() {
        APersistentMap aPersistentMap = this.config();
        Datahike.createDatabase((Map<String, Object>)aPersistentMap);
        Object object = Datahike.connect((Map<String, Object>)aPersistentMap);
        Assert.assertFalse((boolean)Datahike.isFiltered(Datahike.deref(object)));
        Datahike.transact(object, (List)((APersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]")));
        Object object2 = Datahike.filter(Datahike.deref(object), Clojure.read((String)"(fn [_ datom] (not= :age (:a datom)))"));
        Assert.assertTrue((boolean)Datahike.isFiltered(object2));
    }

    @Test
    public void dbWith() {
        APersistentMap aPersistentMap = this.config();
        Datahike.createDatabase((Map<String, Object>)aPersistentMap);
        Object object = Datahike.connect((Map<String, Object>)aPersistentMap);
        APersistentVector aPersistentVector = (APersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]");
        Object object2 = Datahike.dbWith(Datahike.deref(object), (List)aPersistentVector);
        this.query = "[:find ?a :in $ :where [?e :age ?a]]";
        Set set = (Set)Datahike.q(this.query, object2);
        Assert.assertTrue((set.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void databaseBuilderMemoryWithUUID() {
        UUID uUID = UUID.randomUUID();
        Map<String, Object> map = Database.memory(uUID).keepHistory(true).build();
        Assert.assertNotNull(map);
        Assert.assertTrue((boolean)map.containsKey("store"));
        Map map2 = (Map)map.get("store");
        Assert.assertEquals((Object)":memory", map2.get("backend"));
        Assert.assertEquals((Object)uUID, map2.get("id"));
        Assert.assertEquals((Object)true, (Object)map.get("keep-history?"));
    }

    @Test
    public void databaseBuilderMemoryWithString() {
        UUID uUID = UUID.randomUUID();
        String string = uUID.toString();
        Map<String, Object> map = Database.memory(string).schemaFlexibility(SchemaFlexibility.READ).build();
        Map map2 = (Map)map.get("store");
        Assert.assertEquals((Object)uUID, map2.get("id"));
        Assert.assertEquals((Object)":read", (Object)map.get("schema-flexibility"));
    }

    @Test
    public void databaseBuilderFile() {
        Map<String, Object> map = Database.file("/tmp/test-db").keepHistory(false).name("test-database").build();
        Map map2 = (Map)map.get("store");
        Assert.assertEquals((Object)":file", map2.get("backend"));
        Assert.assertEquals((Object)"/tmp/test-db", map2.get("path"));
        Assert.assertEquals((Object)false, (Object)map.get("keep-history?"));
        Assert.assertEquals((Object)"test-database", (Object)map.get("name"));
    }

    @Test
    public void databaseBuilderWithInitialTx() {
        APersistentVector aPersistentVector = Util.vec(Util.map(Util.kwd(":db/ident"), Util.kwd(":test/attr"), Util.kwd(":db/valueType"), Util.kwd(":db.type/string"), Util.kwd(":db/cardinality"), Util.kwd(":db.cardinality/one")));
        Map<String, Object> map = Database.memory(UUID.randomUUID()).initialTx(aPersistentVector).build();
        Assert.assertNotNull((Object)map.get("initial-tx"));
    }

    @Test
    public void databaseBuilderCustomOption() {
        Map<String, Object> map = Database.memory(UUID.randomUUID()).option("temporal-index", true).option("attribute-refs?", false).build();
        Assert.assertEquals((Object)true, (Object)map.get("temporal-index"));
        Assert.assertEquals((Object)false, (Object)map.get("attribute-refs?"));
    }

    @Test
    public void databaseBuilderIntegration() {
        Map<String, Object> map = Database.memory(UUID.randomUUID()).schemaFlexibility(SchemaFlexibility.READ).keepHistory(true).build();
        Datahike.createDatabase(map);
        Assert.assertTrue((boolean)Datahike.databaseExists(map));
        Object object = Datahike.connect(map);
        Assert.assertNotNull((Object)object);
        Datahike.transact(object, (List)Util.vec(Util.map(Util.kwd(":name"), "Test")));
        Object object2 = Datahike.q("[:find ?n :where [?e :name ?n]]", Datahike.deref(object));
        Assert.assertNotNull((Object)object2);
        Datahike.deleteDatabase(map);
        Assert.assertFalse((boolean)Datahike.databaseExists(map));
    }

    public static boolean run() {
        Result result = JUnitCore.runClasses((Class[])new Class[]{DatahikeTest.class});
        System.out.println("\n");
        List list = result.getFailures();
        for (Failure failure : list) {
            System.out.println("Junit Failure: " + failure.toString());
        }
        System.out.println("Java Bindings test failure count: " + list.size());
        return result.wasSuccessful();
    }
}

