/*
 * Decompiled with CFR 0.152.
 */
package datahike.java;

import datahike.java.SchemaFlexibility;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Database {
    private final Map<String, Object> store;
    private final Map<String, Object> config;

    private Database(Map<String, Object> map) {
        this.store = new HashMap<String, Object>(map);
        this.config = new HashMap<String, Object>();
    }

    public static Database memory(UUID uUID) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("backend", ":memory");
        hashMap.put("id", uUID);
        return new Database(hashMap);
    }

    public static Database memory(String string) {
        return Database.memory(UUID.fromString(string));
    }

    public static Database file(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("backend", ":file");
        hashMap.put("path", string);
        return new Database(hashMap);
    }

    public static Database custom(Map<String, Object> map) {
        return new Database(map);
    }

    public Database keepHistory(boolean bl) {
        this.config.put("keep-history?", bl);
        return this;
    }

    public Database schemaFlexibility(SchemaFlexibility schemaFlexibility) {
        this.config.put("schema-flexibility", schemaFlexibility.toEDNString());
        return this;
    }

    public Database initialTx(Object object) {
        this.config.put("initial-tx", object);
        return this;
    }

    public Database name(String string) {
        this.config.put("name", string);
        return this;
    }

    public Database option(String string, Object object) {
        this.config.put(string, object);
        return this;
    }

    public Map<String, Object> build() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.config);
        hashMap.put("store", this.store);
        return hashMap;
    }
}

