/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server.core;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.reficio.ws.annotation.ThreadSafe;
import org.reficio.ws.server.ServiceRegistrationException;
import org.reficio.ws.server.SoapServerException;
import org.reficio.ws.server.endpoint.GenericContextDomEndpoint;
import org.reficio.ws.server.responder.RequestResponder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

@ThreadSafe
public final class SoapServer {
    private static final Logger log = Logger.getLogger(SoapServer.class);
    private Integer httpPort = 8080;
    private Integer httpsPort = 8443;
    private boolean reuseAddress = true;
    private Integer connectionMaxIdleTimeInSeconds = 60;
    private Integer acceptorThreads = 4;
    private Integer coreThreads = 8;
    private Integer maxThreads = 16;
    private Integer threadKeepAliveTimeInSeconds = 60;
    private URL keyStoreUrl;
    private String keyStoreType = "JKS";
    private String keyStorePassword;
    private boolean http;
    private boolean https;
    private ClassPathXmlApplicationContext context;
    private Server server;
    private GenericContextDomEndpoint endpoint;

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception ex) {
            throw new SoapServerException(ex);
        }
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public boolean isStarting() {
        return this.server.isStarting();
    }

    public boolean isStopping() {
        return this.server.isStopping();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }

    public boolean isNotRunning() {
        return this.isStopping() || this.isStopped();
    }

    public boolean isFailed() {
        return this.server.isFailed();
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            throw new SoapServerException(ex);
        }
    }

    public void destroy() {
        this.stop();
        this.context.close();
    }

    public void registerRequestResponder(String contextPath, RequestResponder responder) throws ServiceRegistrationException {
        Preconditions.checkNotNull((Object)contextPath, (Object)"contextPath cannot be null");
        Preconditions.checkNotNull((Object)responder, (Object)"responder cannot be null");
        this.validateUrl(contextPath);
        log.info((Object)String.format("Registering responder [%s] under the url [%s]", responder, this.getUrl(contextPath)));
        this.endpoint.registerRequestResponder(contextPath, responder);
    }

    public void unregisterRequestResponder(String contextPath) throws ServiceRegistrationException {
        Preconditions.checkNotNull((Object)contextPath, (Object)"contextPath cannot be null");
        log.info((Object)String.format("Unregistering responder from the url [%s]", this.getUrl(contextPath)));
        this.endpoint.unregisterRequestResponder(contextPath);
    }

    private String getUrl(String contextPath) {
        String format = String.format("%s://localhost:%d%s", this.http ? "http" : "https", this.http ? this.httpPort : this.httpsPort, contextPath);
        return format;
    }

    private void validateUrl(String contextPath) {
        Preconditions.checkArgument((boolean)contextPath.startsWith("/"), (Object)"contextPath has to begin with a slash");
        String url = this.getUrl(contextPath);
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("URL with context path is malformed [%s]", url), e);
        }
    }

    public List<String> getRegisteredContextPaths() {
        return Collections.list(this.endpoint.getRegisteredContextPaths());
    }

    private void configure() {
        this.configureParentContext();
        this.configureConnectors();
        this.configureWebContext();
    }

    private void configureParentContext() {
        PropertyPlaceholderConfigurer config = new PropertyPlaceholderConfigurer();
        config.setProperties(this.buildProperties());
        this.context = new ClassPathXmlApplicationContext();
        this.context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)config);
        this.context.setConfigLocation("classpath:soap-server.xml");
        this.context.refresh();
        this.context.registerShutdownHook();
        this.server = (Server)this.context.getBean("jettyServer", Server.class);
    }

    private void configureConnectors() {
        if (this.http) {
            SelectChannelConnector httpConnector = (SelectChannelConnector)this.context.getBean("connector", SelectChannelConnector.class);
            this.configureHttpConnector(httpConnector);
            this.server.addConnector((Connector)httpConnector);
        }
        if (this.https) {
            Preconditions.checkNotNull((Object)this.keyStoreUrl, (Object)"keyStore has to be set in https mode");
            SslSelectChannelConnector httpsConnector = (SslSelectChannelConnector)this.context.getBean("sslConnector", SslSelectChannelConnector.class);
            this.configureHttpsConnector(httpsConnector);
            this.server.addConnector((Connector)httpsConnector);
        }
    }

    private SelectChannelConnector configureHttpConnector(SelectChannelConnector connector) {
        this.configureGenericConnector((AbstractConnector)connector);
        connector.setReuseAddress(this.reuseAddress);
        connector.setPort(this.httpPort.intValue());
        return connector;
    }

    private SslSelectChannelConnector configureHttpsConnector(SslSelectChannelConnector connector) {
        this.configureGenericConnector((AbstractConnector)connector);
        connector.setReuseAddress(this.reuseAddress);
        connector.setPort(this.httpsPort.intValue());
        connector.setKeystore(this.keyStoreUrl.toString());
        connector.setKeystoreType(this.keyStoreType);
        connector.setKeyPassword(this.keyStorePassword);
        return connector;
    }

    private AbstractConnector configureGenericConnector(AbstractConnector connector) {
        connector.setAcceptors(this.acceptorThreads.intValue());
        connector.setMaxIdleTime(this.connectionMaxIdleTimeInSeconds * 1000);
        return connector;
    }

    private void configureWebContext() {
        ServletContext servletContext = this.getServletContext();
        GenericWebApplicationContext webContext = new GenericWebApplicationContext();
        webContext.setServletContext(servletContext);
        webContext.setParent((ApplicationContext)this.context);
        webContext.refresh();
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)webContext);
        if (webContext != null) {
            this.endpoint = (GenericContextDomEndpoint)webContext.getBean("endpoint", GenericContextDomEndpoint.class);
        }
    }

    private ServletContext getServletContext() {
        for (Handler handler : this.server.getHandlers()) {
            if (!(handler instanceof Context)) continue;
            return ((Context)handler).getServletContext();
        }
        return null;
    }

    private Properties buildProperties() {
        Properties properties = new Properties();
        properties.setProperty("core.pool.size", this.coreThreads.toString());
        properties.setProperty("max.pool.size", this.maxThreads.toString());
        properties.setProperty("keep.alive.time", this.threadKeepAliveTimeInSeconds.toString());
        return properties;
    }

    private SoapServer() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SoapServer server = new SoapServer();

        public Builder httpPort(int value) {
            Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
            this.server.http = true;
            this.server.httpPort = value;
            return this;
        }

        public Builder httpsPort(int value) {
            Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
            this.server.https = true;
            this.server.httpsPort = value;
            return this;
        }

        public Builder connectionMaxIdleTimeInSeconds(int value) {
            Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
            this.server.connectionMaxIdleTimeInSeconds = value;
            return this;
        }

        public Builder acceptorThreads(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0);
            this.server.acceptorThreads = value;
            return this;
        }

        public Builder coreThreads(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0);
            this.server.coreThreads = value;
            return this;
        }

        public Builder maxThreads(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0);
            this.server.maxThreads = value;
            return this;
        }

        public Builder threadKeepAliveTimeInSeconds(int value) {
            Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
            this.server.threadKeepAliveTimeInSeconds = value;
            return this;
        }

        public Builder keyStoreUrl(URL value) {
            Preconditions.checkNotNull((Object)value);
            this.server.keyStoreUrl = value;
            return this;
        }

        public Builder keyStoreType(String value) {
            Preconditions.checkNotNull((Object)value);
            this.server.keyStoreType = value;
            return this;
        }

        public Builder keyStorePassword(String value) {
            this.server.keyStorePassword = value;
            return this;
        }

        public Builder reuseAddress(boolean value) {
            this.server.reuseAddress = value;
            return this;
        }

        public SoapServer build() {
            this.server.configure();
            return this.server;
        }
    }
}

