/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server.endpoint;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reficio.ws.server.ServiceRegistrationException;
import org.reficio.ws.server.SoapServerException;
import org.reficio.ws.server.endpoint.ContextPayloadEndpoint;
import org.reficio.ws.server.responder.RequestResponder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapMessage;

public class GenericContextDomEndpoint
implements ContextPayloadEndpoint,
InitializingBean {
    private static final Log log = LogFactory.getLog(GenericContextDomEndpoint.class);
    private final ConcurrentHashMap<String, RequestResponder> services = new ConcurrentHashMap();

    @Override
    public Source invoke(MessageContext messageContext) {
        RequestResponder requestResponder = this.getRequestResponderBySessionRequestContextPath();
        if (this.noResponderForRequestFound(requestResponder)) {
            this.handleNoResponderFault();
        }
        SoapMessage msg = (SoapMessage)messageContext.getRequest();
        Source response = requestResponder.respond(msg);
        return response;
    }

    private RequestResponder getRequestResponderBySessionRequestContextPath() {
        HttpServletRequest htpServletRequest = this.getHttpServletRequest();
        return this.getRequestResponderByRequestContextPath(htpServletRequest.getRequestURI());
    }

    private RequestResponder getRequestResponderByRequestContextPath(String contextPath) {
        return this.services.get(contextPath);
    }

    private boolean noResponderForRequestFound(RequestResponder responder) {
        return responder == null;
    }

    private Source handleNoResponderFault() {
        String msg = String.format("There is no service under the requested context path [%s]", this.getRequestContextPath());
        throw new SoapServerException(msg);
    }

    private HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    private String getRequestContextPath() {
        return this.getHttpServletRequest().getRequestURI();
    }

    public void registerRequestResponder(String contextPath, RequestResponder responder) throws ServiceRegistrationException {
        if (this.services.putIfAbsent(contextPath, responder) != null) {
            throw new ServiceRegistrationException(String.format("Specified context path [%s] is already taken", contextPath));
        }
    }

    public void unregisterRequestResponder(String contextPath) throws ServiceRegistrationException {
        if (this.services.remove(contextPath) == null) {
            throw new ServiceRegistrationException(String.format("There was no service under the specified context path [%s]", contextPath));
        }
    }

    public Enumeration<String> getRegisteredContextPaths() {
        return this.services.keys();
    }

    public void afterPropertiesSet() {
        log.info((Object)"Generic SOAP endpoint initialized");
    }

    public Source invoke(Source request) throws Exception {
        throw new SoapServerException("This method is not implemented - it SHOULD NOT be used.");
    }
}

