/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.legacy;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.SoapContext;
import org.reficio.ws.SoapValidationException;
import org.reficio.ws.legacy.SoapMessageBuilder;
import org.reficio.ws.legacy.SoapVersion;
import org.reficio.ws.legacy.WsdlUtils;
import org.reficio.ws.legacy.WsdlValidator;

public class SoapLegacyFacade {
    private static final String RPC = "rpc";
    private SoapMessageBuilder messageBuilder;

    public SoapLegacyFacade(URL wsdlUrl) throws WSDLException {
        this.messageBuilder = new SoapMessageBuilder(wsdlUrl);
    }

    public String buildSoapMessageFromInput(Binding binding, BindingOperation bindingOperation, SoapContext context) {
        try {
            return this.messageBuilder.buildSoapMessageFromInput(binding, bindingOperation, context);
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    public String buildSoapMessageFromOutput(Binding binding, BindingOperation bindingOperation, SoapContext context) {
        try {
            return this.messageBuilder.buildSoapMessageFromOutput(binding, bindingOperation, context);
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    public void validateSoapRequestMessage(Binding binding, BindingOperation operation, String message, boolean strict) {
        WsdlValidator validator = new WsdlValidator(this.messageBuilder, binding);
        List<AssertionError> result = validator.assertRequest(operation, message, strict);
        if (!result.isEmpty()) {
            throw new SoapValidationException(result);
        }
    }

    public void validateSoapResponseMessage(Binding binding, BindingOperation operation, String message, boolean strict) {
        WsdlValidator validator = new WsdlValidator(this.messageBuilder, binding);
        List<AssertionError> result = validator.assertResponse(operation, message, strict);
        if (!result.isEmpty()) {
            throw new SoapValidationException(result);
        }
    }

    public String buildFault(String code, String message, Binding binding, SoapContext context) {
        return this.messageBuilder.buildFault(code, message, binding, context);
    }

    public String buildEmptyFault(Binding binding, SoapContext context) {
        return this.messageBuilder.buildEmptyFault(binding, context);
    }

    public String buildEmptyMessage(Binding binding, SoapContext context) {
        return this.messageBuilder.buildEmptyMessage(binding, context);
    }

    public URL saveWsdl(String rootFileName, File folder) {
        return this.messageBuilder.saveWsdl(rootFileName, folder);
    }

    public static URL saveWsdl(URL wsdlUrl, String rootFileName, File folder) {
        try {
            return SoapMessageBuilder.saveWsdl(rootFileName, wsdlUrl, folder);
        }
        catch (WSDLException e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    public Binding getBindingByName(QName bindingName) {
        return this.messageBuilder.getBindingByName(bindingName);
    }

    public List<QName> getBindingNames() {
        return this.messageBuilder.getBindingNames();
    }

    public static String buildEmptyMessage(SoapVersion soapVersion, SoapContext context) {
        return SoapMessageBuilder.buildEmptyMessage(soapVersion, context);
    }

    public static String buildEmptyFault(SoapVersion soapVersion, SoapContext context) {
        return SoapMessageBuilder.buildEmptyFault(soapVersion, context);
    }

    public static String buildFault(String code, String message, SoapVersion soapVersion, SoapContext context) {
        return SoapMessageBuilder.buildFault(code, message, soapVersion, context);
    }

    private static SoapVersion transformSoapVersion(Soap soapVersion) {
        if (soapVersion.equals((Object)Soap.SOAP_1_1)) {
            return SoapVersion.Soap11;
        }
        return SoapVersion.Soap12;
    }

    public static String buildEmptyMessage(Soap version, SoapContext context) {
        return SoapLegacyFacade.buildEmptyMessage(SoapLegacyFacade.transformSoapVersion(version), context);
    }

    public static String buildEmptyFault(Soap version, SoapContext context) {
        return SoapLegacyFacade.buildEmptyFault(SoapLegacyFacade.transformSoapVersion(version), context);
    }

    public static String buildFault(Soap version, String code, String message, SoapContext context) {
        return SoapLegacyFacade.buildFault(code, message, SoapLegacyFacade.transformSoapVersion(version), context);
    }

    public static boolean isRpc(Binding binding) {
        SOAPBinding soapBinding = WsdlUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAPBinding.class);
        if (soapBinding != null) {
            return RPC.equalsIgnoreCase(soapBinding.getStyle());
        }
        SOAP12Binding soap12Binding = WsdlUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAP12Binding.class);
        if (soap12Binding != null) {
            return RPC.equalsIgnoreCase(soap12Binding.getStyle());
        }
        return false;
    }

    public static String getSoapEndpoint(Port port) {
        return WsdlUtils.getSoapEndpoint(port);
    }

    public Collection<Service> getServices() {
        return this.messageBuilder.getDefinition().getServices().values();
    }

    public boolean isOutputSoapEncoded(BindingOperation operation) {
        return WsdlUtils.isOutputSoapEncoded(operation);
    }

    public boolean isInputSoapEncoded(BindingOperation operation) {
        return WsdlUtils.isInputSoapEncoded(operation);
    }

    public static enum Soap {
        SOAP_1_1,
        SOAP_1_2;

    }
}

