/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.it.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SslTunnel {
    private static final Log log = LogFactory.getLog(SslTunnel.class);
    private final KeyStore trustStore;
    private final KeyStore keyStore;
    private final String keyStorePassword;
    private final int sourcePort;
    private final String targetHost;
    private final int targetPort;
    private final AtomicBoolean run = new AtomicBoolean(true);
    private SSLContext sslContext;
    private ServerSocket socket;
    private CountDownLatch latch = new CountDownLatch(3);
    private List<Socket> clients = new ArrayList<Socket>();

    public SslTunnel(KeyStore keyStore, String keyStorePassword, int sourcePort, String targetHost, int targetPort) {
        this.trustStore = null;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.sourcePort = sourcePort;
        this.targetHost = targetHost;
        this.targetPort = targetPort;
    }

    public SslTunnel(KeyStore keyStore, String keyStorePassword, KeyStore trustStore, int sourcePort, String targetHost, int targetPort) {
        this.trustStore = trustStore;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.sourcePort = sourcePort;
        this.targetHost = targetHost;
        this.targetPort = targetPort;
    }

    public void start() {
        try {
            this.sslContext = SSLContext.getInstance("SSLv3");
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (this.keyStore != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(this.keyStore, this.keyStorePassword.toCharArray());
                X509KeyManager defaultKeyManager = (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
                keyManagers = new KeyManager[]{defaultKeyManager};
            }
            if (this.trustStore != null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(this.trustStore);
                X509TrustManager defaultTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
                trustManagers = new TrustManager[]{defaultTrustManager};
            }
            this.sslContext.init(keyManagers, trustManagers, new SecureRandom());
            SSLServerSocketFactory socketFactory = this.sslContext.getServerSocketFactory();
            this.socket = socketFactory.createServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(this.sourcePort));
            new ServerThread(this.socket, this.run).start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void stop() {
        try {
            this.run.set(false);
            IOUtils.closeQuietly((ServerSocket)this.socket);
            for (Socket client : this.clients) {
                IOUtils.closeQuietly((Socket)client);
            }
            this.latch.await();
        }
        catch (Exception ex) {
            throw new RuntimeException();
        }
    }

    class PipeThread
    extends Thread {
        private final Socket client;
        private final AtomicBoolean run;

        public PipeThread(Socket client, AtomicBoolean run) {
            this.client = client;
            this.run = run;
        }

        @Override
        public void run() {
            try {
                Socket target = new Socket(SslTunnel.this.targetHost, SslTunnel.this.targetPort);
                final InputStream ti = target.getInputStream();
                final OutputStream to = target.getOutputStream();
                target.setSoTimeout(100);
                final InputStream ci = this.client.getInputStream();
                final OutputStream co = this.client.getOutputStream();
                this.client.setSoTimeout(100);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            while (PipeThread.this.run.get()) {
                                try {
                                    int read = 0;
                                    byte[] buffer = new byte[4096];
                                    read = ti.read(buffer);
                                    if (read == -1) break;
                                    co.write(buffer, 0, read);
                                }
                                catch (Exception exception) {}
                            }
                            IOUtils.closeQuietly((Socket)PipeThread.this.client);
                        }
                        finally {
                            SslTunnel.this.latch.countDown();
                        }
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            while (PipeThread.this.run.get()) {
                                try {
                                    int read = 0;
                                    byte[] buffer = new byte[4096];
                                    read = ci.read(buffer);
                                    if (read == -1) {
                                        break;
                                    }
                                    to.write(buffer, 0, read);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((Socket)PipeThread.this.client);
                        }
                        SslTunnel.this.latch.countDown();
                    }
                }.start();
            }
            catch (Exception ex) {
                SslTunnel.this.latch.countDown();
                SslTunnel.this.latch.countDown();
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    class ServerThread
    extends Thread {
        private final ServerSocket server;
        private final AtomicBoolean run;

        public ServerThread(ServerSocket server, AtomicBoolean run) {
            this.server = server;
            this.run = run;
        }

        @Override
        public void run() {
            try {
                this.server.setSoTimeout(100);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (this.run.get()) {
                try {
                    Socket client = this.server.accept();
                    if (client == null) continue;
                    SslTunnel.this.clients.add(client);
                    new PipeThread(client, this.run).start();
                }
                catch (Exception exception) {}
            }
            IOUtils.closeQuietly((ServerSocket)this.server);
            SslTunnel.this.latch.countDown();
        }
    }
}

