/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.it;

import java.security.KeyStore;
import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.littleshoot.proxy.DefaultHttpProxyServer;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.ProxyAuthorizationHandler;
import org.reficio.ws.client.TransmissionException;
import org.reficio.ws.client.core.Security;
import org.reficio.ws.client.core.SoapClient;
import org.reficio.ws.it.AbstractCooperationTest;
import org.reficio.ws.it.util.ClientBuilder;
import org.reficio.ws.it.util.SslTunnel;
import org.reficio.ws.server.core.SoapServer;

public class HttpsProxyHttpsCooperationTest
extends AbstractCooperationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final int PROXY_PORT = 9797;
    private static final int PROXY_SSL_PORT = 9898;
    private SslTunnel tunnel;
    private HttpProxyServer proxyServer;

    @Before
    public void initializeServer() {
        this.server = SoapServer.builder().keyStoreUrl(HttpsProxyHttpsCooperationTest.getKeyStoreUrlOne()).keyStorePassword(this.getKeyStorePassword()).httpsPort(9696).build();
        this.server.start();
        this.tunnel = this.getProxyTunnel();
        this.tunnel.start();
        this.proxyServer = this.getProxy();
        this.proxyServer.start(true, true);
    }

    @After
    public void destroyServer() {
        this.server.stop();
        this.proxyServer.stop();
        this.tunnel.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public HttpProxyServer getProxy() {
        HashMap filters = new HashMap();
        DefaultHttpProxyServer proxyServer = new DefaultHttpProxyServer(9797, filters, null, null, null);
        return proxyServer;
    }

    private Security proxySecurity() {
        Security securityContext = Security.builder().trustStoreUrl(HttpsProxyHttpsCooperationTest.getKeyStoreUrlTwo()).trustStorePassword(this.getKeyStorePassword()).build();
        return securityContext;
    }

    private SslTunnel getProxyTunnel() {
        KeyStore ks = this.readKeyStore(HttpsProxyHttpsCooperationTest.getKeyStoreUrlTwo(), this.getKeyStorePassword(), "JKS");
        SslTunnel tunnel = new SslTunnel(ks, this.getKeyStorePassword(), 9898, "localhost", 9797);
        return tunnel;
    }

    private Security endpointSecurity() {
        Security securityContext = Security.builder().trustStoreUrl(HttpsProxyHttpsCooperationTest.getKeyStoreUrlOne()).trustStorePassword(this.getKeyStorePassword()).build();
        return securityContext;
    }

    @Test
    public void testService1_httpProxy_noAuthentication() throws Exception {
        this.verifyServiceBehavior(1, new ClientBuilder(){

            @Override
            public SoapClient buildClient(String endpointUrl) {
                return SoapClient.builder().endpointUri("https://" + endpointUrl).endpointSecurity(HttpsProxyHttpsCooperationTest.this.endpointSecurity()).proxyUri("https://127.0.0.1:9898").proxySecurity(HttpsProxyHttpsCooperationTest.this.proxySecurity()).build();
            }
        });
    }

    @Test
    public void testService1_httpsProxy_basicAuthentication_success() throws Exception {
        this.proxyServer.addProxyAuthenticationHandler(new ProxyAuthorizationHandler(){

            public boolean authenticate(String user, String pass) {
                return user.equals("tom") && pass.equals("007");
            }
        });
        final Security securityContext = Security.builder().trustStoreUrl(HttpsProxyHttpsCooperationTest.getKeyStoreUrlTwo()).trustStorePassword(this.getKeyStorePassword()).authBasic("tom", "007").build();
        this.verifyServiceBehavior(1, new ClientBuilder(){

            @Override
            public SoapClient buildClient(String endpointUrl) {
                return SoapClient.builder().endpointUri("https://" + endpointUrl).endpointSecurity(HttpsProxyHttpsCooperationTest.this.endpointSecurity()).proxyUri("https://127.0.0.1:9898").proxySecurity(securityContext).build();
            }
        });
    }

    @Test
    public void testService1_httpsProxy_basicAuthentication_failure() throws Exception {
        this.exception.expect(TransmissionException.class);
        this.exception.expectMessage("[407]");
        this.proxyServer.addProxyAuthenticationHandler(new ProxyAuthorizationHandler(){

            public boolean authenticate(String user, String pass) {
                return user.equals("tom") && pass.equals("007");
            }
        });
        final Security securityContext = Security.builder().trustStoreUrl(HttpsProxyHttpsCooperationTest.getKeyStoreUrlTwo()).trustStorePassword(this.getKeyStorePassword()).authBasic("james", "003").build();
        this.verifyServiceBehavior(1, new ClientBuilder(){

            @Override
            public SoapClient buildClient(String endpointUrl) {
                return SoapClient.builder().endpointUri("https://" + endpointUrl).endpointSecurity(HttpsProxyHttpsCooperationTest.this.endpointSecurity()).proxyUri("https://127.0.0.1:9898").proxySecurity(securityContext).build();
            }
        });
    }
}

