/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.it;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.reficio.ws.client.SoapClientException;
import org.reficio.ws.client.core.Security;
import org.reficio.ws.client.core.SoapClient;
import org.reficio.ws.it.AbstractCooperationTest;
import org.reficio.ws.it.util.ClientBuilder;
import org.reficio.ws.server.core.SoapServer;

@RunWith(value=Parameterized.class)
public class HttpsCooperationTest
extends AbstractCooperationTest {
    private URL keyStoreUrl;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    public HttpsCooperationTest(URL url) {
        this.keyStoreUrl = url;
    }

    @Parameterized.Parameters
    public static Collection keyStores() {
        return Arrays.asList({HttpsCooperationTest.getKeyStoreUrlOne()}, {HttpsCooperationTest.getMultiKeyStoreUrl()});
    }

    @Before
    public void initializeServer() {
        this.server = SoapServer.builder().keyStoreUrl(this.keyStoreUrl).keyStorePassword(this.getKeyStorePassword()).httpsPort(9696).build();
        this.server.start();
    }

    @After
    public void destroyServer() {
        this.server.stop();
    }

    @Test
    public void testService1() throws Exception {
        this.verifyServiceBehavior(1, this.client());
    }

    @Test
    public void testService2() throws Exception {
        this.verifyServiceBehavior(2, this.client());
    }

    @Test
    public void testService2_wrongKeyStore_failure() throws Exception {
        this.exception.expect(SoapClientException.class);
        this.exception.expectMessage("not authenticated");
        this.verifyServiceBehavior(2, new ClientBuilder(){

            @Override
            public SoapClient buildClient(String endpointUrl) {
                Security securityContext = Security.builder().trustStoreUrl(AbstractCooperationTest.getKeyStoreUrlTwo()).trustStorePassword(HttpsCooperationTest.this.getKeyStorePassword()).build();
                return SoapClient.builder().endpointUri("https://" + endpointUrl).endpointSecurity(securityContext).build();
            }
        });
    }

    private ClientBuilder client() {
        return new HttpsClientBuilder();
    }

    private class HttpsClientBuilder
    implements ClientBuilder {
        private HttpsClientBuilder() {
        }

        @Override
        public SoapClient buildClient(String endpointUrl) {
            Security securityContext = Security.builder().trustStoreUrl(HttpsCooperationTest.this.keyStoreUrl).trustStorePassword(HttpsCooperationTest.this.getKeyStorePassword()).build();
            return SoapClient.builder().endpointUri("https://" + endpointUrl).endpointSecurity(securityContext).build();
        }
    }
}

