/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.common;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.reficio.ws.SoapException;
import org.reficio.ws.common.FileWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Wsdl11Writer {
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    private File baseFolder = null;
    private int count;

    public Wsdl11Writer(File baseFolder) {
        this.baseFolder = baseFolder;
        this.count = 0;
    }

    public void writeWSDL(String name, Definition definition) {
        try {
            HashMap<String, String> baseURIwsdlNameMap = new HashMap<String, String>();
            baseURIwsdlNameMap.put(definition.getDocumentBaseURI(), name + ".wsdl");
            this.writeWSDL(definition, name + ".wsdl", new HashMap<String, String>(), baseURIwsdlNameMap);
        }
        catch (Exception e) {
            throw new SoapException("WSDL writing failed!", e);
        }
    }

    private void writeWSDL(Definition definition, String fileName, Map<String, String> changedMap, Map baseURIwsdlNameMap) throws Exception {
        Map imports = definition.getImports();
        if (imports != null && imports.size() > 0) {
            Vector importsVector2 = null;
            Import wsdlImport2 = null;
            String wsdlName = null;
            String wsdlLocation = null;
            for (Vector importsVector2 : imports.values()) {
                for (Import wsdlImport2 : importsVector2) {
                    wsdlLocation = wsdlImport2.getDefinition().getDocumentBaseURI();
                    if (!baseURIwsdlNameMap.containsKey(wsdlLocation)) {
                        wsdlName = wsdlLocation.substring(wsdlLocation.lastIndexOf(47) + 1);
                        if (!wsdlName.endsWith(".wsdl") && !wsdlName.endsWith(".xsd")) {
                            wsdlName = wsdlName.indexOf("xsd") > -1 ? "xsd" + this.count++ + ".xsd" : "wsdl" + this.count++ + ".wsdl";
                        }
                        while (baseURIwsdlNameMap.containsValue(wsdlName)) {
                            String fileNamePart = wsdlName.substring(0, wsdlName.lastIndexOf("."));
                            String extension = wsdlName.substring(wsdlName.lastIndexOf("."));
                            wsdlName = fileNamePart + this.count++ + extension;
                        }
                        wsdlName = this.normalizeName(wsdlName);
                        baseURIwsdlNameMap.put(wsdlLocation, wsdlName);
                        Definition innerDefinition = wsdlImport2.getDefinition();
                        this.writeWSDL(innerDefinition, wsdlName, changedMap, baseURIwsdlNameMap);
                    }
                    wsdlImport2.setLocationURI((String)baseURIwsdlNameMap.get(wsdlLocation));
                }
            }
        }
        this.processSchemas(definition, changedMap);
        WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
        File outputFile = new FileWriter().createClassFile(this.baseFolder, null, fileName, null);
        FileOutputStream out = new FileOutputStream(outputFile);
        if (definition.getServices().size() > 1) {
            ArrayList<Service> removedServices = new ArrayList<Service>();
            ArrayList servicesList = new ArrayList();
            Map services = definition.getServices();
            Iterator iter = services.values().iterator();
            while (iter.hasNext()) {
                servicesList.add(iter.next());
            }
            String serviceNameFromFileName = fileName;
            if (fileName.indexOf(".wsdl") > -1) {
                serviceNameFromFileName = fileName.substring(0, fileName.lastIndexOf(".wsdl"));
            }
            if (fileName.indexOf(".xsd") > -1) {
                serviceNameFromFileName = fileName.substring(0, fileName.lastIndexOf(".xsd"));
            }
            for (Service service : servicesList) {
                if (service.getQName().getLocalPart().equals(serviceNameFromFileName)) continue;
                definition.removeService(service.getQName());
                removedServices.add(service);
            }
            wsdlWriter.writeWSDL(definition, (OutputStream)out);
            for (Service service : removedServices) {
                definition.addService(service);
            }
        } else {
            wsdlWriter.writeWSDL(definition, (OutputStream)out);
        }
        out.flush();
        out.close();
    }

    private void processSchemas(Definition definition, Map<String, String> changedSchemaLocations) {
        Types wsdlTypes = definition.getTypes();
        if (wsdlTypes != null) {
            List extensibilityElements = wsdlTypes.getExtensibilityElements();
            for (Object currentObject : extensibilityElements) {
                if (!(currentObject instanceof Schema)) continue;
                Schema schema = (Schema)currentObject;
                this.processSchema(definition, schema, null, changedSchemaLocations);
            }
        }
    }

    private void processSchema(Definition definition, Schema schema, String fileName, Map<String, String> changedSchemaLocations) {
        try {
            if (schema.getIncludes() != null) {
                for (Object o : schema.getIncludes()) {
                    if (!(o instanceof SchemaReference)) continue;
                    SchemaReference ref = (SchemaReference)o;
                    String fileNameChild = this.normalizeName(ref.getSchemaLocationURI());
                    Schema includedSchema = ref.getReferencedSchema();
                    if (includedSchema == null) continue;
                    changedSchemaLocations.put(ref.getSchemaLocationURI(), fileNameChild);
                    this.processSchema(definition, includedSchema, fileNameChild, changedSchemaLocations);
                }
            }
            if (schema.getImports() != null && schema.getImports().values() != null) {
                for (Object o : schema.getImports().values()) {
                    for (Object oi : (Vector)o) {
                        SchemaImport imp;
                        Schema importedSchema;
                        if (!(oi instanceof SchemaImport) || (importedSchema = (imp = (SchemaImport)oi).getReferencedSchema()) == null) continue;
                        String fileNameChild = this.normalizeName(imp.getSchemaLocationURI());
                        changedSchemaLocations.put(imp.getSchemaLocationURI(), fileNameChild);
                        this.processSchema(definition, importedSchema, fileNameChild, changedSchemaLocations);
                    }
                }
            }
            this.changeLocations(schema.getElement(), changedSchemaLocations);
            if (fileName != null) {
                java.io.FileWriter writer = new java.io.FileWriter(new File(this.baseFolder, fileName));
                DOM2Writer.serializeAsXML((Node)schema.getElement(), (Map)definition.getNamespaces(), (Writer)writer);
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            throw new SoapException("Unexpected error", ex);
        }
    }

    private void changeLocations(Element element, Map<String, String> changedSchemaLocations) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String tagName = nodeList.item(i).getLocalName();
            if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
            this.processImport(nodeList.item(i), changedSchemaLocations);
        }
    }

    private void processImport(Node importNode, Map<String, String> changedSchemaLocations) {
        NamedNodeMap nodeMap = importNode.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node attribute = nodeMap.item(i);
            if (!attribute.getNodeName().equals(SCHEMA_LOCATION)) continue;
            String attributeValue = attribute.getNodeValue();
            if ((attributeValue = changedSchemaLocations.get(attributeValue)) == null) continue;
            attribute.setNodeValue(attributeValue);
        }
    }

    private String normalizeName(String name) {
        if (name != null) {
            return name.replaceAll("[^A-Za-z0-9.\\-_]", "_");
        }
        return null;
    }
}

