/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.common;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;

public class ResourceUtils {
    public static URL getResourceWithAbsolutePackagePath(String absolutePackagePath, String resourceName) {
        return ResourceUtils.getResourceWithAbsolutePackagePath(ResourceUtils.class, absolutePackagePath, resourceName);
    }

    private static String getFullPath(String resourcePath) {
        int windowsIndex;
        int linuxIndex = resourcePath.lastIndexOf("/");
        int index = Math.max(linuxIndex, windowsIndex = resourcePath.lastIndexOf("\\"));
        if (index < 0) {
            return "";
        }
        return resourcePath.substring(0, index);
    }

    private static Path parsePath(String resourcePath) {
        Preconditions.checkNotNull((Object)resourcePath, (Object)"resourcePath cannot be null");
        Path path = new Path();
        path.packagePath = ResourceUtils.getFullPath(resourcePath);
        path.resourcePath = FilenameUtils.getName((String)resourcePath);
        return path;
    }

    public static URL getResource(String resourcePath) {
        Path path = ResourceUtils.parsePath(resourcePath);
        return ResourceUtils.getResourceWithAbsolutePackagePath(path.packagePath, path.resourcePath);
    }

    public static URL getResource(Class<?> clazz, String resourcePath) {
        Path path = ResourceUtils.parsePath(resourcePath);
        return ResourceUtils.getResourceWithAbsolutePackagePath(clazz, path.packagePath, path.resourcePath);
    }

    public static InputStream getResourceAsStream(String resourcePath) {
        Path path = ResourceUtils.parsePath(resourcePath);
        return ResourceUtils.getResourceWithAbsolutePackagePathAsStream(path.packagePath, path.resourcePath);
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String resourcePath) {
        Path path = ResourceUtils.parsePath(resourcePath);
        return ResourceUtils.getResourceWithAbsolutePackagePathAsStream(clazz, path.packagePath, path.resourcePath);
    }

    public static URL getResourceWithAbsolutePackagePath(Class<?> clazz, String absolutePackagePath, String resourceName) {
        Preconditions.checkNotNull(clazz, (Object)"clazz cannot be null");
        String resourcePath = ResourceUtils.getResourcePath(absolutePackagePath, resourceName);
        URL resource = null;
        resource = clazz.getClass().getResource(resourcePath);
        if (resource == null && resourcePath.charAt(0) == '/') {
            String resourcePathWithoutLeadingSlash = resourcePath.substring(1);
            resource = Thread.currentThread().getContextClassLoader().getResource(resourcePathWithoutLeadingSlash);
        }
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)String.format("Resource [%s] loading failed", resourcePath));
        return resource;
    }

    public static InputStream getResourceWithAbsolutePackagePathAsStream(String absolutePackagePath, String resourceName) {
        return ResourceUtils.getResourceWithAbsolutePackagePathAsStream(ResourceUtils.class, absolutePackagePath, resourceName);
    }

    public static InputStream getResourceWithAbsolutePackagePathAsStream(Class<?> clazz, String absolutePackagePath, String resourceName) {
        ClassLoader classLoader;
        Preconditions.checkNotNull(clazz, (Object)"clazz cannot be null");
        String resourcePath = ResourceUtils.getResourcePath(absolutePackagePath, resourceName);
        InputStream resource = null;
        resource = clazz.getClass().getResourceAsStream(resourcePath);
        if (resource == null && (classLoader = clazz.getClass().getClassLoader()) != null) {
            resource = classLoader.getResourceAsStream(resourcePath);
        }
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)String.format("Resource [%s] loading failed", resourcePath));
        return resource;
    }

    private static String getResourcePath(String absolutePackagePath, String resourceName) {
        Preconditions.checkNotNull((Object)absolutePackagePath, (Object)"absolutePackagePath cannot be null");
        Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName cannot be null");
        absolutePackagePath = ResourceUtils.formatArgument(absolutePackagePath);
        resourceName = ResourceUtils.formatArgument(resourceName);
        return ResourceUtils.constructResourcePath(absolutePackagePath, resourceName);
    }

    private static String formatArgument(String argument) {
        String argumentWithoutWhiteSpaces = argument.trim();
        return argumentWithoutWhiteSpaces;
    }

    private static String constructResourcePath(String packagePath, String resourceName) {
        String resourcePath = String.format("/%s/%s", packagePath, resourceName);
        String resourcePathUnixSeparators = FilenameUtils.separatorsToUnix((String)resourcePath);
        String resourcePathNoLeadingSeparators = ResourceUtils.removeLeadingUnixSeparators(resourcePathUnixSeparators);
        String normalizedResourcePath = FilenameUtils.normalizeNoEndSeparator((String)resourcePathNoLeadingSeparators, (boolean)true);
        return normalizedResourcePath;
    }

    private static String removeLeadingUnixSeparators(String argument) {
        return argument.replaceAll("/+", "/");
    }

    private static class Path {
        String packagePath = "";
        String resourcePath = "";

        private Path() {
        }
    }
}

