/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.common;

import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlComparator {
    private boolean nodeTypeDiff = true;
    private boolean nodeValueDiff = true;

    public boolean diff(String xml1, String xml2, List<String> diffs) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new ByteArrayInputStream(xml1.getBytes()));
        Document doc2 = db.parse(new ByteArrayInputStream(xml2.getBytes()));
        doc1.normalizeDocument();
        doc2.normalizeDocument();
        return this.diff(doc1, doc2, diffs);
    }

    public boolean diff(Node node1, Node node2, List<String> diffs) throws Exception {
        if (this.diffNodeExists(node1, node2, diffs)) {
            return true;
        }
        if (this.nodeTypeDiff) {
            this.diffNodeType(node1, node2, diffs);
        }
        if (this.nodeValueDiff) {
            this.diffNodeValue(node1, node2, diffs);
        }
        this.diffAttributes(node1, node2, diffs);
        this.diffNodes(node1, node2, diffs);
        return diffs.size() > 0;
    }

    public boolean diffNodes(Node node1, Node node2, List<String> diffs) throws Exception {
        LinkedHashMap<String, Node> children1 = new LinkedHashMap<String, Node>();
        for (Node child1 = node1.getFirstChild(); child1 != null; child1 = child1.getNextSibling()) {
            children1.put(child1.getNodeName(), child1);
        }
        LinkedHashMap<String, Node> children2 = new LinkedHashMap<String, Node>();
        for (Node child2 = node1.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            children2.put(child2.getNodeName(), child2);
        }
        for (Node child1 : children1.values()) {
            Node child2 = (Node)children2.remove(child1.getNodeName());
            this.diff(child1, child2, diffs);
        }
        for (Node child2 : children2.values()) {
            Node child1 = (Node)children1.get(child2.getNodeName());
            this.diff(child1, child2, diffs);
        }
        return diffs.size() > 0;
    }

    public boolean diffAttributes(Node node1, Node node2, List<String> diffs) throws Exception {
        NamedNodeMap nodeMap1 = node1.getAttributes();
        LinkedHashMap<String, Node> attributes1 = new LinkedHashMap<String, Node>();
        for (int index = 0; nodeMap1 != null && index < nodeMap1.getLength(); ++index) {
            attributes1.put(nodeMap1.item(index).getNodeName(), nodeMap1.item(index));
        }
        NamedNodeMap nodeMap2 = node2.getAttributes();
        LinkedHashMap<String, Node> attributes2 = new LinkedHashMap<String, Node>();
        for (int index = 0; nodeMap2 != null && index < nodeMap2.getLength(); ++index) {
            attributes2.put(nodeMap2.item(index).getNodeName(), nodeMap2.item(index));
        }
        for (Node attribute1 : attributes1.values()) {
            Node attribute2 = (Node)attributes2.remove(attribute1.getNodeName());
            this.diff(attribute1, attribute2, diffs);
        }
        for (Node attribute2 : attributes2.values()) {
            Node attribute1 = (Node)attributes1.get(attribute2.getNodeName());
            this.diff(attribute1, attribute2, diffs);
        }
        return diffs.size() > 0;
    }

    public boolean diffNodeExists(Node node1, Node node2, List<String> diffs) throws Exception {
        if (node1 == null && node2 == null) {
            diffs.add(this.getPath(node2) + ":node " + node1 + "!=" + node2 + "\n");
            return true;
        }
        if (node1 == null && node2 != null) {
            diffs.add(this.getPath(node2) + ":node " + node1 + "!=" + node2.getNodeName());
            return true;
        }
        if (node1 != null && node2 == null) {
            diffs.add(this.getPath(node1) + ":node " + node1.getNodeName() + "!=" + node2);
            return true;
        }
        return false;
    }

    public boolean diffNodeType(Node node1, Node node2, List<String> diffs) throws Exception {
        if (node1.getNodeType() != node2.getNodeType()) {
            diffs.add(this.getPath(node1) + ":type " + node1.getNodeType() + "!=" + node2.getNodeType());
            return true;
        }
        return false;
    }

    public boolean diffNodeValue(Node node1, Node node2, List<String> diffs) throws Exception {
        if (node1.getNodeValue() == null && node2.getNodeValue() == null) {
            return false;
        }
        if (node1.getNodeValue() == null && node2.getNodeValue() != null) {
            diffs.add(this.getPath(node1) + ":type " + node1 + "!=" + node2.getNodeValue());
            return true;
        }
        if (node1.getNodeValue() != null && node2.getNodeValue() == null) {
            diffs.add(this.getPath(node1) + ":type " + node1.getNodeValue() + "!=" + node2);
            return true;
        }
        if (!node1.getNodeValue().equals(node2.getNodeValue())) {
            diffs.add(this.getPath(node1) + ":type " + node1.getNodeValue() + "!=" + node2.getNodeValue());
            return true;
        }
        return false;
    }

    public String getPath(Node node) {
        StringBuilder path = new StringBuilder();
        do {
            path.insert(0, node.getNodeName());
            path.insert(0, "/");
        } while ((node = node.getParentNode()) != null);
        return path.toString();
    }
}

