/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.client.core;

import com.google.common.base.Preconditions;
import java.security.KeyStore;
import org.reficio.ws.client.core.Security;
import org.reficio.ws.client.core.SoapConstants;

public class SecurityFactory {
    private KeyStore trustStore;
    private String trustStoreUrl;
    private String trustStorePassword;
    private String trustStoreType;
    private KeyStore keyStore;
    private String keyStoreUrl;
    private String keyStorePassword;
    private String keyStoreType;
    private String authUsername;
    private String authPassword;
    private String authWorkstation;
    private String authDomain;
    private String authMethod;
    private Boolean strictHostVerification;
    private String sslContextProtocol;

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = (KeyStore)Preconditions.checkNotNull((Object)trustStore);
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = (String)Preconditions.checkNotNull((Object)trustStorePassword);
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = (String)Preconditions.checkNotNull((Object)trustStoreType);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = (KeyStore)Preconditions.checkNotNull((Object)keyStore);
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = (String)Preconditions.checkNotNull((Object)keyStorePassword);
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = (String)Preconditions.checkNotNull((Object)keyStoreType);
    }

    public String getAuthUsername() {
        return this.authUsername;
    }

    public void setAuthUsername(String authUsername) {
        this.authUsername = (String)Preconditions.checkNotNull((Object)authUsername);
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = (String)Preconditions.checkNotNull((Object)authPassword);
    }

    public String getAuthWorkstation() {
        return this.authWorkstation;
    }

    public void setAuthWorkstation(String authWorkstation) {
        this.authWorkstation = (String)Preconditions.checkNotNull((Object)authWorkstation);
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public void setAuthDomain(String authDomain) {
        this.authDomain = (String)Preconditions.checkNotNull((Object)authDomain);
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = ((String)Preconditions.checkNotNull((Object)authMethod)).toUpperCase().trim();
    }

    public Boolean getStrictHostVerification() {
        return this.strictHostVerification;
    }

    public void setStrictHostVerification(Boolean strictHostVerification) {
        this.strictHostVerification = (Boolean)Preconditions.checkNotNull((Object)strictHostVerification);
    }

    public String getSslContextProtocol() {
        return this.sslContextProtocol;
    }

    public void setSslContextProtocol(String sslContextProtocol) {
        this.sslContextProtocol = (String)Preconditions.checkNotNull((Object)sslContextProtocol);
    }

    public Security create() {
        Security.Builder builder = Security.builder();
        this.configureKeyStore(builder);
        this.configureTrustStore(builder);
        this.configureAuthentication(builder);
        this.configureTransport(builder);
        return builder.build();
    }

    private void configureKeyStore(Security.Builder builder) {
        if (this.keyStore != null) {
            builder.keyStore(this.keyStore);
        }
        if (this.keyStoreUrl != null) {
            builder.keyStoreUrl(this.keyStoreUrl);
        }
        if (this.keyStorePassword != null) {
            builder.keyStorePassword(this.keyStorePassword);
        }
        if (this.keyStoreType != null) {
            builder.keyStoreType(this.keyStoreType);
        }
    }

    private void configureTrustStore(Security.Builder builder) {
        if (this.trustStore != null) {
            builder.trustStore(this.trustStore);
        }
        if (this.trustStoreUrl != null) {
            builder.trustStoreUrl(this.trustStoreUrl);
        }
        if (this.trustStorePassword != null) {
            builder.trustStorePassword(this.trustStorePassword);
        }
        if (this.trustStoreType != null) {
            builder.trustStoreType(this.trustStoreType);
        }
    }

    private void configureAuthentication(Security.Builder builder) {
        if (this.authMethod != null) {
            SoapConstants.AuthMethod method = SoapConstants.AuthMethod.valueOf(this.authMethod);
            if (method.equals((Object)SoapConstants.AuthMethod.BASIC)) {
                builder.authBasic(this.authUsername, this.authPassword);
            } else if (method.equals((Object)SoapConstants.AuthMethod.DIGEST)) {
                builder.authDigest(this.authUsername, this.authPassword);
            } else if (method.equals((Object)SoapConstants.AuthMethod.NTLM)) {
                builder.authNtlm(this.authUsername, this.authPassword, this.authWorkstation, this.authDomain);
            } else if (method.equals((Object)SoapConstants.AuthMethod.SPNEGO)) {
                builder.authSpnego();
            }
        }
    }

    private void configureTransport(Security.Builder builder) {
        if (this.strictHostVerification != null) {
            builder.strictHostVerification(this.strictHostVerification);
        }
        if (this.sslContextProtocol != null) {
            builder.sslContextProtocol(this.sslContextProtocol);
        }
    }
}

