/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.SoapContext;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.core.Wsdl;
import org.reficio.ws.common.ResourceUtils;

public class WsdlTest {
    @Test(expected=NullPointerException.class)
    public void testParseNullUrl() {
        Wsdl.parse((String)null);
    }

    @Test(expected=SoapBuilderException.class)
    public void testParseWrongUrl() throws MalformedURLException {
        URL wsdlUrl = new URL("http://asd.com/asd.wsdl");
        Wsdl parser = Wsdl.parse((URL)wsdlUrl);
        Assert.assertNotNull((Object)parser);
    }

    @Test
    public void testParseTestWsdl() {
        URL wsdlUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"wsdl", (String)"TestService.wsdl");
        Wsdl parser = Wsdl.parse((URL)wsdlUrl);
        Assert.assertNotNull((Object)parser);
        List bindings = parser.getBindings();
        String expectedBindingString = "{http://schemas.eviware.com/TestService/v1/}TestServiceSoap";
        QName expectedBinding = QName.valueOf(expectedBindingString);
        junit.framework.Assert.assertEquals((int)1, (int)bindings.size());
        junit.framework.Assert.assertEquals((Object)expectedBinding, bindings.iterator().next());
        Assert.assertNotNull((Object)parser.binding().name(expectedBindingString).find());
        Assert.assertNotNull((Object)parser.binding().name(expectedBinding).find());
    }

    @Test(expected=NullPointerException.class)
    public void testParseTestWsdlNullContext() {
        URL wsdlUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"wsdl", (String)"TestService.wsdl");
        Wsdl parser = Wsdl.parse((URL)wsdlUrl);
        String expectedBindingString = "{http://schemas.eviware.com/TestService/v1/}TestServiceSoap";
        parser.binding().name(expectedBindingString).find(null);
    }

    @Test
    public void testParseTestWsdlProperContext() {
        URL wsdlUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"wsdl", (String)"TestService.wsdl");
        Wsdl parser = Wsdl.parse((URL)wsdlUrl);
        String expectedBindingString = "{http://schemas.eviware.com/TestService/v1/}TestServiceSoap";
        SoapContext context = SoapContext.builder().typeComments(true).build();
        SoapBuilder builder = parser.binding().name(expectedBindingString).find(context);
        junit.framework.Assert.assertEquals((Object)context, (Object)builder.getContext());
    }
}

