/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.reficio.ws.SoapContext;
import org.reficio.ws.common.ResourceUtils;
import org.reficio.ws.legacy.SoapLegacyFacade;

public class MessageComplianceTest {
    private static final Logger log = Logger.getLogger(MessageComplianceTest.class);
    private static SoapContext context = SoapContext.builder().exampleContent(false).typeComments(false).alwaysBuildHeaders(false).valueComments(false).buildOptional(true).build();

    public static String getContent(String folderPath, String fileName) {
        URL fileUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)folderPath, (String)fileName);
        File file = null;
        try {
            file = new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(fileUrl.getPath());
        }
        try {
            return FileUtils.readFileToString((File)file).trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testEmptyFaultSoap11() {
        String emptyFaultSoap11 = SoapLegacyFacade.buildEmptyFault((SoapLegacyFacade.Soap)SoapLegacyFacade.Soap.SOAP_1_1, (SoapContext)context);
        log.info((Object)("\n" + emptyFaultSoap11));
        String expectedMsg = MessageComplianceTest.getContent("messages", "EmptyFault11.xml");
        Assert.assertEquals((Object)expectedMsg, (Object)emptyFaultSoap11);
    }

    @Test
    public void testEmptyFaultSoap12() {
        String emptyFaultSoap12 = SoapLegacyFacade.buildEmptyFault((SoapLegacyFacade.Soap)SoapLegacyFacade.Soap.SOAP_1_2, (SoapContext)context);
        log.info((Object)("\n" + emptyFaultSoap12));
        String expectedMsg = MessageComplianceTest.getContent("messages", "EmptyFault12.xml");
        Assert.assertEquals((Object)expectedMsg, (Object)emptyFaultSoap12);
    }

    @Test
    public void testFaultSoap11() {
        String faultSoap11 = SoapLegacyFacade.buildFault((SoapLegacyFacade.Soap)SoapLegacyFacade.Soap.SOAP_1_1, (String)"VersionMismatch", (String)"Fault Message", (SoapContext)context);
        log.info((Object)("\n" + faultSoap11));
        String expectedMsg = MessageComplianceTest.getContent("messages", "FaultVersionMismatch11.xml");
        Assert.assertEquals((Object)expectedMsg, (Object)faultSoap11);
    }

    @Test
    public void testFaultSoap12() {
        String faultSoap12 = SoapLegacyFacade.buildFault((SoapLegacyFacade.Soap)SoapLegacyFacade.Soap.SOAP_1_2, (String)"VersionMismatch", (String)"Fault Message", (SoapContext)context);
        log.info((Object)("\n" + faultSoap12));
        String expectedMsg = MessageComplianceTest.getContent("messages", "FaultVersionMismatch12.xml");
        Assert.assertEquals((Object)expectedMsg, (Object)faultSoap12);
    }

    @Test
    public void testEmptyMessageSoap11() {
        String emptyMessageSoap11 = SoapLegacyFacade.buildEmptyMessage((SoapLegacyFacade.Soap)SoapLegacyFacade.Soap.SOAP_1_1, (SoapContext)context);
        log.info((Object)("\n" + emptyMessageSoap11));
        String expectedMsg = MessageComplianceTest.getContent("messages", "EmptyMessage11.xml");
        Assert.assertEquals((Object)expectedMsg, (Object)emptyMessageSoap11);
    }

    @Test
    public void testEmptyMessageSoap12() {
        String emptyMessageSoap12 = SoapLegacyFacade.buildEmptyMessage((SoapLegacyFacade.Soap)SoapLegacyFacade.Soap.SOAP_1_2, (SoapContext)context);
        log.info((Object)("\n" + emptyMessageSoap12));
        String expectedMsg = MessageComplianceTest.getContent("messages", "EmptyMessage12.xml");
        Assert.assertEquals((Object)expectedMsg, (Object)emptyMessageSoap12);
    }
}

