/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.wsdl.WSDLException;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.junit.Test;
import org.reficio.ws.builder.ServiceComplianceTest;
import org.reficio.ws.builder.core.Wsdl;

public class DefinitionSaveTest {
    public static File getServiceFolder(int serviceId) {
        URL definitionUrl = ServiceComplianceTest.getDefinitionUrl(serviceId);
        File definitionFile = new File(definitionUrl.getFile());
        File serviceFolder = new File(definitionUrl.getFile()).getParentFile();
        if (!serviceFolder.exists()) {
            throw new RuntimeException("Cannot get service folder for service " + serviceId);
        }
        return serviceFolder;
    }

    public static File createTempFolder(String name) throws IOException {
        File tempFolder = File.createTempFile(name, Long.toString(System.nanoTime()));
        if (!tempFolder.delete()) {
            throw new RuntimeException("cannot delete tmp file");
        }
        if (!tempFolder.mkdir()) {
            throw new RuntimeException("cannot create tmp folder");
        }
        return tempFolder;
    }

    public static File getGeneratedFolder(int serviceId) throws WSDLException, IOException {
        URL wsdlUrl = ServiceComplianceTest.getDefinitionUrl(serviceId);
        File tempFolder = File.createTempFile("maven-temp", Long.toString(System.nanoTime()));
        if (!tempFolder.delete()) {
            throw new RuntimeException("cannot delete tmp file");
        }
        if (!tempFolder.mkdir()) {
            throw new RuntimeException("cannot create tmp folder");
        }
        String fileName = FilenameUtils.getBaseName((String)wsdlUrl.toString());
        File rootWsdl = new File(tempFolder, fileName);
        Wsdl.saveWsdl((URL)wsdlUrl, (File)rootWsdl);
        tempFolder.deleteOnExit();
        return tempFolder;
    }

    public static List<String> getFileNames(File folder) {
        boolean RECURSIVE = true;
        String[] extensions = new String[]{"wsdl", "xsd"};
        Collection files = FileUtils.listFiles((File)folder, (String[])extensions, (boolean)true);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : files) {
            fileNames.add(file.getName());
        }
        return fileNames;
    }

    public static File findFile(File folder, String name) {
        boolean RECURSIVE = true;
        String[] extensions = new String[]{FilenameUtils.getExtension((String)name)};
        Collection files = FileUtils.listFiles((File)folder, (String[])extensions, (boolean)true);
        if (!files.isEmpty()) {
            return (File)files.iterator().next();
        }
        throw new RuntimeException("File not found " + name);
    }

    public static void testDefinitionSave(int serviceId) {
        try {
            File serviceFolder = DefinitionSaveTest.getServiceFolder(serviceId);
            File generatedFolder = DefinitionSaveTest.getGeneratedFolder(serviceId);
            List<String> serviceFileNames = DefinitionSaveTest.getFileNames(serviceFolder);
            List<String> generatedFileNames = DefinitionSaveTest.getFileNames(generatedFolder);
            Collections.sort(serviceFileNames);
            Collections.sort(generatedFileNames);
            Assert.assertEquals((String)("serviceId " + serviceId), (int)serviceFileNames.size(), (int)generatedFileNames.size());
            for (int i = 0; i < serviceFileNames.size(); ++i) {
                String srvFileName = serviceFileNames.get(i);
                String genFileName = null;
                for (int j = 0; j < generatedFileNames.size(); ++j) {
                    String tmp = generatedFileNames.get(j);
                    if (!tmp.endsWith(srvFileName) && !tmp.equals(srvFileName)) continue;
                    genFileName = generatedFileNames.get(j);
                    break;
                }
                Assert.assertNotNull((String)("serviceId " + serviceId + " " + srvFileName + " vs. " + genFileName), (Object)genFileName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("serviceId " + serviceId, e);
        }
    }

    @Test
    public void testDefinitionSaveService() {
        for (int serviceId = 1; serviceId <= 18; ++serviceId) {
            DefinitionSaveTest.testDefinitionSave(serviceId);
        }
    }
}

