/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder;

import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.builder.SoapOperationFinder;
import org.reficio.ws.builder.core.Wsdl;
import org.reficio.ws.common.ResourceUtils;

public class SoapOperationFinderImplTest {
    public SoapOperationFinder operation() {
        URL wsdlUrl = ResourceUtils.getResourceWithAbsolutePackagePath((String)"wsdl", (String)"TestService.wsdl");
        Wsdl parser = Wsdl.parse((URL)wsdlUrl);
        String binding = "{http://schemas.eviware.com/TestService/v1/}TestServiceSoap";
        return parser.binding().name(binding).find().operation();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFinderNoArguments() {
        this.operation().find();
    }

    @Test(expected=NullPointerException.class)
    public void testFinderWrongArgument() {
        this.operation().name(null).find();
    }

    @Test(expected=SoapBuilderException.class)
    public void testFinderNoOperation() {
        this.operation().name("asd").find();
    }

    @Test
    public void testFindOk() {
        Assert.assertNotNull((Object)this.operation().name("GetDefaultPageData").find());
    }

    @Test(expected=SoapBuilderException.class)
    public void testFindNameOkWrongAction() {
        this.operation().name("GetDefaultPageData").soapAction("asdasdasd").find();
    }
}

