; This Source Code Form is subject to the terms of the Mozilla Public License,
; v. 2.0. If a copy of the MPL was not distributed with this file, You can
; obtain one at http://mozilla.org/MPL/2.0/.

(ns cemerick.splice.uuid
  (:require [cemerick.splice.hosty :refer (now current-time-ms)]))

     
(defn uuid? [x] (instance? java.util.UUID x))
      
                                             

;; would go look at the default readers to get the fn that's used to 
;; read uuid string literals, but that's `default-data-readers` in Clojure
;; (keyed by symbols) and `*tag-table*` in ClojureScript (keyed by strings)!!!
     
(defn uuid
  [string]
  (if (uuid? string)
    string
    (java.util.UUID/fromString string)))

      
          
          
                    
          
                              

     
(def ^:private rng (java.security.SecureRandom.))
     
(defn time-uuid*
  "Returns a sequential UUID. Guaranteed to:

(a) monotonically increase when printed lexicographically
(b) contain [time] (or the current time in millis) as the most significant bits"
  ([] (time-uuid* (current-time-ms)))
  ([time] (java.util.UUID. time (.nextLong rng))))

      
              
         
                          
                              
                                                             
                 

      
                   
            
                                                             
                                                       
                           
                                  
                     
                    

      
                                  
      
                
                                     
                                                          

(defn uuid-str
  [uuid]
        (str uuid)
                      )

(def time-uuid (comp uuid-str time-uuid*))

     
(defn random-uuid* [] (java.util.UUID/randomUUID))

;; TODO upgrade this to use window.crypto ASAP
;; Sourced from http://stackoverflow.com/a/2117523, clever
      
                     
                                                        
                                 
                 
                                    
                                      
                                                                 
                     

(def random-uuid (comp uuid-str random-uuid*))


;;;;;;;;;;;; This file autogenerated from src/cljx/cemerick/splice/uuid.cljx
