(defproject org.quilt/sedan "0.0.4"
  :description "encoding scalar and simple aggregate data with a static lexicographical ordering matching a defined runtime collation order"
  :url "http://github.com/QuiltProject/splice"
  :license {:name "Mozilla Public License v2.0+"
            :url "https://www.mozilla.org/MPL/"}
  :java-source-paths ["src/java"]
  :jar-exclusions [#"\.java|\.cljx|\.swp|\.swo|\.DS_Store"]
  :source-paths ["src/clj" "src/cljs" "src/cljx" "target/classes"]
  :test-paths ["test/clj" "test/cljs" "test/cljx" "target/test-classes"]
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/clojurescript "0.0-2202"]]
  :cljx {:builds [{:source-paths ["src/cljx"]
                   :output-path "target/classes"
                   :rules :clj}

                  {:source-paths ["test/cljx"]
                   :output-path "target/test-classes"
                   :rules :clj}

                  {:source-paths ["src/cljx"]
                   :output-path "target/classes"
                   :rules :cljs}

                  {:source-paths ["test/cljx"]
                   :output-path "target/test-classes"
                   :rules :cljs}]}

  :cljsbuild {:test-commands {"node" ["node" :node-runner "target/testable.js"]}
              :builds [{:source-paths ["target/classes" "target/test-classes"]
                        :compiler {:output-to "target/testable.js"
                                   :optimizations :advanced
                                   :libs [""]
                                   :pretty-print true}}]}

  :jvm-opts ["-Xmx256m"]
  :profiles {:dev {:dependencies [[com.cemerick/double-check "0.5.7"]
                                  [com.google.guava/guava "14.0.1"]]
                   :aliases {"cleantest" ["with-profile" "rigorous" "quicktest"]
                             "quicktest" ["do" "clean," "cljx" "once," "test," "cljsbuild" "test"]
                             "cljs-quicktest" ["do" "clean," "cljx" "once," "cljsbuild" "test"]
                             "deploy" ["do" "clean" ["cljx" "once"] ["deploy" "clojars"]]}
                   :plugins [[com.keminglabs/cljx "0.3.3-SNAPSHOT"]
                             [lein-cljsbuild "1.0.4-SNAPSHOT"]
                             [com.cemerick/austin "0.1.5-SNAPSHOT"]
                             [com.cemerick/clojurescript.test "0.3.0"]]}
             ; pushes the number of trials run in tests up to some (conservative) absurd level
             :rigorous [:default
                        {:jvm-opts ["-Dsedan.quickcheck-times=5000000"]
                         :cljsbuild {:test-commands {"node"
                                                     ^:replace ["node" :node-runner "this.sedan_quickcheck_times='5000000'" "target/testable.js"]}}}]}

  
  :deploy-repositories {"releases" {:url "https://oss.sonatype.org/service/local/staging/deploy/maven2/"
                                    :creds :gpg}
                        "snapshots" {:url "https://oss.sonatype.org/content/repositories/snapshots/"
                                     :creds :gpg}}

  ;;maven central requirements
  :scm {:url "https://github.com/QuiltProject/sedan.git"}
  :pom-addition [:developers [:developer
                              [:name "Chas Emerick"]
                              [:url "http://cemerick.com"]
                              [:email "chas@cemerick.com"]
                              [:timezone "-5"]]])

