(defproject org.pupcus/jdbc-clj "0.0.1"

  :description "basic jdbc crud and utility functions"

  :url "https://bitbucket.org/pupcus/jdbc-clj"

  :scm {:url "git@bitbucket.org:pupcus/jdbc-clj"}

  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[org.clojure/tools.logging "0.3.1"]
                 [org.clojure/java.jdbc "0.6.1"]
                 [clj-time "0.13.0"]
                 [honeysql "0.8.2"]]

  :profiles {:dev {:resource-paths ["dev-resources"]
                   :dependencies [[org.clojure/clojure "1.8.0"]
                                  [org.slf4j/slf4j-log4j12 "1.7.5"]]}
             :test {:dependencies [[kosmos "0.0.6"]
                                   [kosmos/kosmos-hikari "0.0.3"]
                                   [kosmos/kosmos-hsqldb-server "0.0.2"]]}}

  :deploy-repositories [["snapshots"
                         {:url "https://clojars.org/repo"
                          :creds :gpg}]
                        ["releases"
                         {:url "https://clojars.org/repo"
                          :creds :gpg}]]

  :global-vars {*warn-on-reflection* true
                *assert* false})
