(ns pinkgorilla.notebook-ui.views.theme
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [reagent.core :as r]
   ;[pinkgorilla.ui.config :refer [#_link-css res-href]]
   [webly.user.config.core :refer [#_link-css res-href]]
   [pinkgorilla.notebook-ui.eval-result.code-viewer :refer [code-viewer-css-link-for-settings]]
   [pinkgorilla.notebook-ui.codemirror.theme :refer [codemirror-css-urls-for-settings]]))

; dynamically loading css will not work the first time
; the editor is shown. css might get rendered after codemirror. 

(defn  css-link-load-cb [href on-load]
  [:link {:rel "stylesheet"
          :href (res-href href)
          :on-load (fn [x y]
                     (error "loaded: " href)
                     (on-load))}])

(defn show-after-css-loaded [css-links child]
  (let [counter-loaded (r/atom 0)
        inc-counter (fn [] (swap! counter-loaded inc))]
    (fn [css-links child]
      [:div.w-full.h-full
       (map-indexed (fn [i l]
                      ^{:key i}
                      [css-link-load-cb l inc-counter]) css-links)
       (if (>= @counter-loaded (count css-links))
         child
         ;[:p "yess"]
         [:h1 "Css loading.."])])))

(defn notebook-css-links-settings [settings]
  (into ["webly/prose.css"
         (code-viewer-css-link-for-settings settings)]
        (codemirror-css-urls-for-settings settings)))

(defn notebook-css [settings child]
  (let [css-links (notebook-css-links-settings settings)
        _ (error "links:" css-links)]
    [show-after-css-loaded css-links
     child]))