(ns pinkgorilla.notebook-ui.app.pages.gorilla-ui
  (:require
   [re-frame.core :as rf]
   [webly.web.handler :refer [reagent-page]]
   [pinkgorilla.ui.css :refer [components config]]
   [example.component :refer [example-component]]
   [pinkgorilla.notebook-ui.app.site :refer [main-with-header demo-header]]
   ;[pinkgorilla.notebook-ui.app.menu :refer [home-menu]]
   ))

(rf/dispatch [:css/add-components components config])

(defmethod reagent-page :gorilla-ui/example [{:keys [route-params query-params handler] :as route}]
  (let [category-str (:category route-params)
        category (if category-str
                   (if (= category-str "all")
                     nil
                     (namespace (symbol category-str "foo")))
                   nil)
        ;nsf (namespace :viz/all)
        ]
    (println "category: " category)
    [main-with-header
     demo-header
     [example-component category]]))