(ns pinkgorilla.notebook-ui.app.app
  (:require
   [taoensso.timbre :refer [info warn]]
   ; webly
   [webly.config :refer [load-config! get-in-config]]
   [webly.profile :refer [server?]]
   [webly.user.app.app :refer [webly-run!]]
   [webly.web.handler :refer [add-ring-handler]]
   ; explorer
   [pinkgorilla.explore.handler :refer [explore-directories-start]]
   ; goldly
   [goldly.app :refer [goldly-run!]]
   ; nrepl relay
   [pinkgorilla.nrepl.relay.jetty :as relay]
   [pinkgorilla.nrepl.server.nrepl-server :refer [run-nrepl-server]]
    ; side effects
   [picasso.default-config]
   [pinkgorilla.notebook-ui.default-config]
   [pinkgorilla.notebook-ui.app.routes]))

(defn nrepl-relay-start []
   ; relay: see resources/config.edn :jetty-ws
  (let [{:keys [server relay]} (get-in-config [:nrepl])
        nrepl-ws-handler (relay/ws-handler relay)]
    (run-nrepl-server server)
    (add-ring-handler :ws/nrepl nrepl-ws-handler)))

(defn -main
  [profile-name]
  (load-config!)
  (let [config-explorer-server (get-in-config [:explorer :server])
        relay-enabled  (get-in-config [:nrepl :enabled])
        goldly-enabled (get-in-config [:goldly :enabled])]
    (when (server? profile-name)
      (info "open http://localhost:8000/demo to see the demos")
      (if relay-enabled
        (nrepl-relay-start)
        (warn "nrepl-relay is disabed!"))
      (explore-directories-start config-explorer-server)
      (if goldly-enabled
        (goldly-run!)
        (warn "goldly is disabed!")))
    (webly-run! profile-name)))