(ns pinkgorilla.notebook-ui.app.css
  (:require
   [webly.user.css.helper :refer [add-themes]]
   [pinkgorilla.notebook-ui.eval-result.code-viewer :as highlight]
   [pinkgorilla.notebook-ui.codemirror.theme :as codemirror]))

(def components
  {:codemirror (add-themes
                {true ["codemirror/lib/codemirror.css"]}
                "codemirror/theme/%s.css"
                codemirror/themes)
   :highlight (add-themes
               {}
               "highlight.js/styles/%s.css"
               highlight/themes-main)
   :punk {true ["notebook-ui/punk.css"]}
   :datatypes {true ["notebook-ui/datatypes.css"]}
   :recom {true [;"notebook-ui/bootstrap.css"
                 "notebook-ui/re-com.css"]}
   ;:markdown-react [true ["react-markdown-editor-lite/lib/index.css"]]
   :prose-mirror {true ["prosemirror-view/style/prosemirror.css"
                        "prosemirror-menu/style/menu.css"
                        "notebook-ui/prosemirror-gorilla.css"]}
   ;:tailwind-prose {true ["https://unpkg.com/@tailwindcss/typography@0.2.x/dist/typography.min.css"]}
   })

(def config
  {:codemirror "paraiso-dark" ;true
   :highlight "github" ; "default"
   :punk true
   :datatypes true
   :recom false
   ;:markdown-react false
   :prose-mirror true
   ;:tailwind false
   ;:tailwind-prose true
   })