(ns pinkgorilla.notebook-ui.app.app
  (:require
   [taoensso.timbre :refer [info warn]]
   ; webly
   [webly.config :refer [load-config! get-in-config]]
   [webly.profile :refer [server?]]
   [webly.user.app.app :refer [webly-run!]]
   [webly.web.handler :refer [add-ring-handler]]
   ; explorer
   [pinkgorilla.explore.handler :refer [explore-directories-start]]
   ; goldly
   [goldly.app :refer [goldly-run!]]
   ; nrepl relay
   [pinkgorilla.nrepl.relay.jetty :as relay]
   [pinkgorilla.nrepl.server.nrepl-server :refer [run-nrepl-server]]
    ; side effects
   [picasso.default-config]
   [pinkgorilla.notebook-ui.default-config]
   [pinkgorilla.notebook-ui.app.routes]))

(defn nrepl-relay-start []
  (let [{:keys [enabled server relay]} (get-in-config [:nrepl])
        nrepl-ws-handler (relay/ws-handler relay)]
    (if enabled
      (do
        (run-nrepl-server server)
        (add-ring-handler :ws/nrepl nrepl-ws-handler))
      (warn "nrepl-repay is disabed!"))
     ; relay: see resources/config.edn :jetty-ws
    ))

(defn -main
  [profile-name]
  (load-config!)
  (let [config-explorer-server (get-in-config [:explorer :server])]
    (when (server? profile-name)
      (info "open http://localhost:8000/demo to see the demos")
      (nrepl-relay-start)
      (explore-directories-start config-explorer-server)
      (goldly-run!))
    (webly-run! profile-name)))