(ns pinkgorilla.notebook-ui.eval-result.eval-result
  (:require
   [pinkgorilla.notebook-ui.eval-result.console :refer [console-view]]
   [pinkgorilla.notebook-ui.eval-result.error :refer [error-text]]
   [pinkgorilla.notebook-ui.eval-result.stacktrace :refer [stacktrace-table]]
   [pinkgorilla.notebook-ui.eval-result.picasso :refer [picasso-cell]]
   [pinkgorilla.notebook-ui.eval-result.datafy :refer [datafy-link]]))

(defn eval-result-view-pure [{:keys [picasso out stacktrace] :as result}]
  [:<>
   [error-text result]

   (when stacktrace
     [stacktrace-table result])

   [datafy-link result]

   (when out
     [console-view out])

   (if picasso
     [picasso-cell picasso]
     [:div.flex-grow-1 ""])])

(defn eval-result-view [result]
  [:div.w-full.h-full.bg-gray-200.flex.flex-col.flex-grow-1.eval-result ; .mt-2
   [eval-result-view-pure result]])
