(ns pinkgorilla.notebook-ui.views.segment
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.eval-result.code-viewer :refer [code-view]]
   [pinkgorilla.notebook-ui.eval-result.code :refer [code-edit]]
   [pinkgorilla.notebook-ui.codemirror.codemirror-edit  :refer [codemirror-edit]]
   [pinkgorilla.notebook-ui.views.md :refer [md-segment-edit md-segment-view]]))

;; input


(defn segment-input-md [{:keys [segment-active?
                                settings-md-editor] :as cm-opt} eval-result]
  (when segment-active?
    (case settings-md-editor
      :codemirror [codemirror-edit eval-result cm-opt]
      :text [md-segment-edit eval-result]
      [md-segment-edit eval-result])
    ;[md-segment-view eval-result]
    ))

(defn segment-input-code [{:keys [segment-active?
                                  settings-code-editor
                                  settings-code-viewer] :as cm-opt} eval-result]
  [:div {:style {:position "relative"}} ; container for kernel absolute position
   ; kernel - one color for both dark and light themes.
   (when-let [kernel (:kernel eval-result)] ; snippets might not define kernel
     [:span.pr-2.text-right.text-blue-600.tracking-wide.font-bold.border.border-blue-300.rounded
      {:on-click #(dispatch [:segment-active/kernel-toggle])
       :style {:position "absolute"
               :z-index 200 ; dialog is 1040 (we have to be lower)
               :top "2px" ; not too big, so it works for single-row code segments
               :right "10px"
               :width "50px"
               :height "22px"}} kernel])
   (if segment-active?
     (case settings-code-editor
       :codemirror  [codemirror-edit eval-result cm-opt]
       :text        [code-edit eval-result]
       [code-edit eval-result])
     (case settings-code-viewer
       :codemirror   [codemirror-edit eval-result cm-opt]
       :highlight-js [code-view eval-result]
       [code-view eval-result]))])

(defn segment-input [{:keys [id code md] :as eval-result}]
  (let [settings (subscribe [:settings])
        segment-active (subscribe [:notebook/segment-active])
        segment-queued (subscribe [:segment/queued? id])
        cm-md-edit? (subscribe [:notebook/edit?])]
    (fn [{:keys [id code md] :as eval-result}]
      (let [{:keys [code-editor code-viewer md-editor]
             :or {code-editor :codemirror
                  code-viewer :highlight-js
                  md-editor :text}}  @settings
            active? (= (:id @segment-active) id)
            cm-md-edit? @cm-md-edit?
            queued? @segment-queued
            options  {:segment-active? active?
                      :cm-md-edit? cm-md-edit?
                      :settings-md-editor md-editor
                      :settings-code-editor code-editor
                      :settings-code-viewer code-viewer}
            full? (= (:layout @settings) :single)]
        [:div.text-left.bg-gray-100 ; .border-solid
         {:id id
          :on-click #(do
                       (dispatch [:notebook/move :to id])
                       (dispatch [:notebook/set-cm-md-edit true]))
          :class (str (if queued?
                        "border border-solid border-blue-600"
                        (if active?
                          (if cm-md-edit? "border border-solid border-red-600"
                              "border border-solid border-gray-600")
                          ""))
                      (if full? " h-full" ""))}

         (cond
           code [segment-input-code options eval-result]
           md   [segment-input-md options eval-result])]))))

;; output

(defn segment-output [{:keys [code md] :as eval-result}]
  [:div
   (when md
     [md-segment-view eval-result])
   (when code
     [eval-result-view eval-result])])





