(ns pinkgorilla.notebook-ui.buffer.notebook
  (:require
   [taoensso.timbre :refer-macros (info)]
   [reagent.core :as r]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [pinkgorilla.ui.config :refer [link-css]]
   [pinkgorilla.notebook-ui.buffer :refer [move]]
   [pinkgorilla.notebook-ui.codemirror.editor :refer [code-mirror-reagent]]))

(defn notebook-buffer [buffer-id options]
  (let [buffer (subscribe [:buffer/view buffer-id])]
    (fn [buffer-id options]
      [:div.w-full.h-full.bg-red-200 ; if this is :<> then it can fuck up flexbox styling
     ; dynamically loading css will not work the first time
     ; the editor is shown. css might get rendered after codemirror. 
       [link-css "codemirror/lib/codemirror.css"]
       [code-mirror-reagent buffer options]])))

(defn notebook [options]
  (let [current-id (r/atom :scratchpad)
        sort (subscribe [:buffer/sort])
        move (fn [dir] (reset! current-id (move @sort @current-id dir)))
        move-up (fn [] (move :up))
        move-down (fn [] (move :up))
        options-notebook {:move-up move-up
                          :move-down move-down}]
    (fn [options]
      [notebook-buffer @current-id (merge options-notebook options)])))

