(ns pinkgorilla.notebook-ui.views.stacktrace
  (:require
   [reagent.dom]
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkie.text :refer [text]]
   [reepl.helpers :as helpers]))

(def styles
  {:error-text {:font-family "monospace"
                :border-style "solid"
                :border-width "1px"
                :border-color "#ff0000"
                :color "#ff0000"
                :clear "both"
                :padding "0.5em 1em 0.5em 1em"
                :margin-bottom "0.3em"
    ;background-color "#faf0f2"
                }
   :stack-trace {:font-family "monospace"
                 :border-style "solid"
                 :border-width "1px"
                 :border-color "#ff0000"
                 :color "#ff0000"
                 :clear "both"
                 :padding "0.5em 1em 0.5em 1em"
                 :margin-bottom "0.3em"
                 :background-color "white"}

   :console-text {:padding "0.5em 1em 0.5em 1em"
                  :margin-bottom "0.3em"
                  :font-family "monospace"
                  :font-size "12px"
                  :color "steelblue"
                  :border-color "#cccccc"
                  :border-style "solid"
                  :border-width "1px"
                  :background-color "#FFFFFF"
                  :word-wrap "break-word"}

   :console-text_pre {; not yet sure how to get this
                      :white-space "pre-wrap"}})

(def view (partial helpers/view styles))

(defn error-text [text]
  [view :error-text text])

(defn console-text [txt]
  [view :console-text
   [text txt]])

(defn stacktrace-line [idx {:keys [type file line method flags ns fn]}]
  (let [tooling? (contains? flags :tooling)
        row-classes (str (name type) (when tooling? " tooling-stackframe"))]
    ^{:key idx}
    [:tr {:class row-classes}
     (case type
       :clj [:<>
             [:td [:span.text-blue-900 ns]]
             [:td [:span.text-blue-900 fn]]
             [:td [:span.text-blue-900 (str file ": " line)]]]
       :java [:<>
              [:td]
              [:td [:span.text-green-300 method]]
              [:td [:span.text-green-300 (str file ": " line)]]]
       [:<>
        [:td]
        [:td [:span.text-red-300 method]]
        [:td [:span.text-red-300 (str file ": " line)]]])]))

(defn stacktrace-table [e]
  (let [ex (if (:cause e) (:cause e) e)]
    [view :stack-traces
     ; Exception
     [:div.text-red-500
      [:div {:class "exception-header"} (if (:cause e)
                                          "An exception was caused by: "
                                          "Exception thrown")]
      [:span (:class ex)]
      [:span (:class ex)]]
     ;Stacktrace
     [:table.w-full.text-md.bg-white.shadow-md.rounded.mb-4
      [:tbody
       (map-indexed stacktrace-line (:stacktrace ex))]]]))

(register-component :p/stacktrace stacktrace-table)

