(ns pinkgorilla.notebook-ui.components.completion
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop]]
   [reagent.ratom :refer [reaction]])
  (:require
   [taoensso.timbre :refer-macros [debug info]]
   [cljs.core.async :as async :refer [<! >! chan timeout close!]]
   [reagent.core :as r]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]

   [pinkgorilla.notebook-ui.views.completion :refer [completion-list]]
   [pinkgorilla.notebook-ui.views.docstring :refer [docs-view]]))

; active completion component:

(reg-event-db
 :completions/set
 (fn [db [_ active]]
   (dispatch [:nrepl/docstring (:candidate active) (:ns active)])
   (assoc-in db [:nrepl :completion :active] active)))

(defn indices [pred coll]
  (keep-indexed #(when (pred %2) %1) coll))

(defn current-index [active candidates]
  (first (indices #(= active %) candidates)))

(reg-event-db
 :completions/next
 (fn [db [_]]
   (when-let [candidates (get-in db [:nrepl :completion :candidates])]
     (let [active (get-in db [:nrepl :completion :active])
           idx (current-index active candidates)
           n-idx (min (- (count candidates) 1) (+ idx 1))
           n-active (get candidates n-idx)]
       (info "next completion: " n-active)
       (dispatch [:completions/set n-active])))
   db))

(reg-event-db
 :completions/prior
 (fn [db [_]]
   (when-let [candidates (get-in db [:nrepl :completion :candidates])]
     (let [active (get-in db [:nrepl :completion :active])
           idx (current-index active candidates)
           p-idx (max 0 (- idx 1))
           p-active (get candidates p-idx)]
       (info "prior completion: " p-active)
       (dispatch [:completions/set p-active])))
   db))

(reg-sub
 :nrepl/completion
 (fn [db _]
   (get-in db [:nrepl :completion])))

(reg-event-db
 :completions/show-all
 (fn [db [_ show-all]]
   (info "show-all: " show-all)
   (assoc-in db [:nrepl :completion :show-all] show-all)))

(reg-event-db
 :completions/hide
 (fn [db [_]]
   (info "hiding completions")
   db))

(reg-event-db
 :completions/clear
 (fn [db [_]]
   (info "clearing completions")
   db))

(defn completion-component []
  (let [ncomp (subscribe [:nrepl/completion])]
    (fn []
      (let [i @ncomp
            cc (:candidates i)
            ds (:docstring i)
            active (:active i)
            show-all (:show-all i)
            _ (debug "nrepl-completion candidates: "  cc " docstring: " ds)]
        [:div
         [:h1 "nrepl active completions"]
         ;(when i
         [completion-list {:pos 1
                           :list cc ;  (map :candidate cc)
                           :active active
                           :show-all show-all
                           :set-active (fn [a]
                                         (info "set active: " a)
                                         (dispatch [:completions/set a]))}]
         [docs-view ds]
         ;[completion-view cc ds]
         ]))))

