(ns pinkgorilla.notebook-ui.codemirror.buffer
  (:require
   [taoensso.timbre :refer-macros [info]]
   [reagent.core :as r]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [cljs.reader]
   [cljs.tools.reader]
   [pinkgorilla.notebook-ui.codemirror.options :refer [settings]]))


; code state


(def value-atom (r/atom "(+ 7 7)(println 11)"))

(defn on-change [t]
  (info "code-mirror code got changed!")
  ;(info "code-mirror new text: " t)
  (reset! value-atom t))

; switch buffer?

(defn go-up? [inst source]
  (let [pos (.getCursor inst)]
    (= 0 (.-line pos))))

(defn go-down? [inst source]
  (let [pos (.getCursor inst)
        last-line (.lastLine inst)]
    (= last-line (.-line pos))))

(reg-event-db
 :buffer/up
 (fn [db [_]]
   (info ":buffer/up")
   db))

(reg-event-db
 :buffer/down
 (fn [db [_]]
   (info ":buffer/down")
   db))




