(ns pinkgorilla.notebook-ui.codemirror.editor
  (:require
   [taoensso.timbre :refer-macros [debug info warn]]
   [reagent.core :as r]
   [reagent.dom :as rd]
   [re-frame.core :refer [dispatch subscribe]]
   ["codemirror" :as CodeMirror]
   ["codemirror/addon/edit/closebrackets"]
   ["codemirror/addon/edit/matchbrackets"]
   ["codemirror/addon/hint/show-hint"]
   ["codemirror/addon/runmode/runmode"]
   ["codemirror/addon/runmode/colorize"]
   ["codemirror/mode/clojure/clojure"]
   ["codemirror/mode/markdown/markdown"]
   ; [cljsjs.codemirror.mode.xml]
   ; [cljsjs.codemirror.mode.javascript]
   ; ["parinfer-codemirror"]
   ; [cljsjs.codemirror.mode.clojure-parinfer]
   ;["codemirror/keymap/vim"]
   [pinkgorilla.notebook-ui.codemirror.theme]
   [pinkgorilla.notebook-ui.codemirror.highlight]
   [pinkgorilla.notebook-ui.codemirror.extension.buffer-sync :refer [load-code2 get-data]]
   [pinkgorilla.notebook-ui.codemirror.key-binding :refer [on-key-down on-key-up]]
   [pinkgorilla.notebook-ui.codemirror.options :refer [cm-default-opts]]
   [pinkgorilla.notebook-ui.codemirror.extension :refer [run-extension]]
   [pinkgorilla.notebook-ui.codemirror.extensions :refer [cm-fun]]))

(defn on-mousedown [eval-result cm evt]
  (debug "on-mousedown " (:id eval-result))
  (dispatch [:notebook/set-edit? true])
  (dispatch [:notebook/move :to (:id eval-result)]))

(defn focus-cm!
  [cm]
  (when cm
    (.focus cm)))

(defn blur-cm!
  [cm]
  (when cm
    (let [input (.getInputField cm)]
      (.blur input))))

(defn focus-active-on-edit [id opts cm]
  (when (and (:active? opts) (:edit? opts))
    (info "focusing cm  " id " .. ")
    (focus-cm! cm)
    (dispatch [:codemirror/set-active id cm])))

(defn blur-active-not-edit [id opts cm]
  (let [{:keys [edit? active?]} opts]
    (when (and active? (not edit?))
      (info "blurring cm " id " .. " "active:" active? "edit?:" edit?)
      (blur-cm! cm))))

(defn destroy-editor [cm-a]
  (if @cm-a
    (do (.toTextArea @cm-a)
        (reset! cm-a nil))
    (warn "Could not kill CodeMirror instance")))

(defn codemirror-reagent
  "code-mirror editor"
  [eval-result cm-opts]
  (let [opts  (merge
               cm-fun
               cm-default-opts
               cm-opts)
        cm (atom nil)
        er-a (atom eval-result)
        run (fn [handler]
              (run-extension {:cm-opts opts
                              :cm cm
                              :eval-result @er-a} handler))]
    (r/create-class
     {:component-did-mount
      (fn [this]
        (let [el (rd/dom-node this)
              opts-js (clj->js opts)
              ;_ (info "component-did-mount: cm")
              ;cm_ (CodeMirror. el opts-js)
              cm_ (.fromTextArea CodeMirror el opts-js)
              code (get-data eval-result)]
          (reset! cm cm_)

          (info "component-did-mount eval-result" (pr-str eval-result))
          (info "component-did-mount: cm code : " code)
          (.setValue cm_ code)

          ; theme - already set in cm constructor
          ;(.setOption inst "theme" (:theme opts))

          (.on cm_ "change" (fn [] (run [:save-code])))
          ;(.on cm_ "keydown"  (partial on-key-down opts))
          ; (.on inst "keyup"  on-key-up)         

          (.on cm_ "mousedown" #(on-mousedown @er-a @cm %))

          (blur-active-not-edit (:id eval-result) opts @cm)
          (focus-active-on-edit (:id eval-result) opts @cm)

          ;(when on-cm-init (on-cm-init inst))
          ))

      :component-will-unmount
      (fn [this]
        (info "cm component-will-unmount")
        (destroy-editor cm))

      :component-did-update
      (fn [this old-argv]
        (let [[_ eval-result opts] (r/argv this)]
          ;(info "component-did-update: current buffer: " eval-result9
          (reset! er-a eval-result)
          (load-code2 cm eval-result)
          #_(run [:load-code])
          (blur-active-not-edit (:id eval-result) opts @cm)
          (focus-active-on-edit (:id eval-result) opts @cm)
          ;
          ))

      :reagent-render
      (fn []
        (let [{:keys [readOnly]} opts]
          ;(info "read-only?: " readOnly)
          (if readOnly
            [:textarea {:read-only true}]
            [:textarea])))})))



