(ns pinkgorilla.notebook-ui.eval-result.eval-result
  (:require
   [pinkgorilla.notebook-ui.eval-result.console :refer [console-view]]
   [pinkgorilla.notebook-ui.eval-result.error :refer [error-text]]
   [pinkgorilla.notebook-ui.eval-result.stacktrace :refer [stacktrace-table]]
   [pinkgorilla.notebook-ui.eval-result.picasso :refer [picasso-cell]]
   [pinkgorilla.notebook-ui.eval-result.datafy :refer [datafy-link]]))

(defn eval-result-view [{:keys [picasso out stacktrace] :as result}]
  [:div.w-full ; .mt-2

   [error-text result]

   (when stacktrace
     [stacktrace-table result])

   [datafy-link result]

   (when out
     [console-view out])

   (when picasso
     [picasso-cell picasso])])

