(ns pinkgorilla.notebook-ui.keybindings.setup
  (:require
   [re-frame.core :as r :refer [reg-event-db dispatch]]
   [taoensso.timbre :refer-macros [infof info]]
   [keybind.core :as key]))

(def current (atom 0))

(defn id []
  (swap! current inc)
  (keyword (str @current)))

(defn reframe-handler [handler evt]
  (info "keybinding triggered handler: " handler " evt: " evt)
  (dispatch handler)
  (.preventDefault evt) ; important, so that the "s" in "alt-g s" does not end in editor
  )

(defn bind-key [{:keys [kb handler]}]
  (infof "binding %s to %s" kb handler)
  (key/bind! kb (id) (partial reframe-handler handler)))

(defn ^:export init-keybindings!
  [keybindings]
  (doall (for [kb keybindings]
           (bind-key kb))))

