(ns pinkgorilla.notebook-ui.codemirror.buffer
  (:require
   [reagent.core :as r]
   [re-frame.core :refer [dispatch dispatch-sync subscribe]]
   [cljs.reader]
   [cljs.tools.reader]
   [pinkgorilla.notebook-ui.codemirror.options :refer [settings]]))


; code state


(def value-atom (r/atom "OOOOO\r\n(+ 7 7)\r\n(println 11)"))

(defn on-change [t]
  (println "code-mirror new text: " t)
  (reset! value-atom t))

; switch buffer?

(defn should-go-up [source inst]
  #_(let [pos (.getCursor inst)]
      (= 0 (.-line pos)))
  false)

(defn should-go-down [source inst]
  #_(let [pos (.getCursor inst)
          last-line (.lastLine inst)]
      (= last-line (.-line pos)))
  false)

   ;; TODO if the cursor is inside a list, and the function doesn't have enought
   ;; arguments yet, then return false
   ;; e.g. (map |) <- map needs at least one argument.

(defn go-up [& a]
  (println "go-up"))

(defn go-down [& a]
  (println "go-down"))



