(ns pinkgorilla.notebook-ui.notebook.events-codemirror
  (:require
   [taoensso.timbre :as timbre :refer [debug warn error] :refer-macros [info errorf]]
   [cljs.reader]
   [cljs.tools.reader]
   [re-frame.core :refer [reg-event-db dispatch]]
   [pinkgorilla.notebook-ui.notebook.events-segment :refer [codemirror-segment-op]]
   [pinkgorilla.notebook-ui.codemirror.extension.completion :refer [cm-current-word]]))

; completions go to cider which uses compliment
; https://github.com/alexander-yakushev/compliment/wiki/Exampleshttps://github.com/alexander-yakushev/compliment/wiki/Examples
; :ns The namespace is which to look for completions (falls back to *ns* if not specified)
; :prefix The prefix for completion candidates
; :context Completion context for compliment.
; :extra-metadata List of extra-metadata fields. Possible values: arglists, doc.

(defn cm-op-complete-get [document segment cm]
  (let [namespace (or (:ns document) "*ns*")
        context ""
        word (cm-current-word cm)]
    (if (empty? word)
      (warn "no current word - cannot get hint!")
      (do
        (info "getting code-completion for ns: " namespace "word: " word)
        (dispatch [:completion/hint word namespace context])))
    segment  ; completion does not change segment 
    ))

(reg-event-db
 :codemirror/completion-get
 (fn [db [_]]
   (codemirror-segment-op db cm-op-complete-get)))