(ns pinkgorilla.notebook-ui.notebook.events
  (:require
   [taoensso.timbre :as timbre :refer [debug warn error] :refer-macros [info errorf]]
   [cljs.reader]
   [cljs.tools.reader]
   [re-frame.core :refer [reg-event-db reg-sub]]))

(reg-event-db
 :notebook/init
 (fn [db [_]]
   (let [db (or db {})]
     (assoc-in db [:notebook] nil))))

(reg-event-db
 :notebook/activate!
 (fn [db [_ storage]]
   (assoc-in db [:notebook] storage)))

(defn current-notebook [db]
  (let [storage (:notebook db)
        document (get-in db [:document :documents storage])]
    document))

(defn change-current-notebook [db notebook]
  (let [storage (:notebook db)]
    (assoc-in db [:document :documents storage] notebook)))

(defn notebook-op [db fun]
  (let [document (current-notebook db)]
    (if document
      (let [d (fun document)]
        ;(info "document: " d)
        (change-current-notebook db d))
      (do (error "cannot do notebook-op: no active document!")
          db))))

(reg-event-db
 :notebook/meta-set
 (fn [db [_ k v]]
   (info "changing notebook meta " k " to: " v)
   (notebook-op db #(assoc-in % [:meta k] v))))


