(ns pinkgorilla.notebook-ui.nrepl.connect-ui
  (:require
   [re-frame.core :refer [subscribe]]))

(defn connect-ui []
  (let [nrepl (subscribe [:nrepl])]
    (fn []
      (let [{:keys [ws-url connected?]} @nrepl]
        (if connected?
          [:p "Connected to: " ws-url]
          [:div
           [:h1 "nrepl connect"]
           [:p "the url where you connect to has run nrepl-relay"]
           [:p "connect to:"]
           [:input {:value ws-url}]])))))

