(ns pinkgorilla.notebook-ui.nrepl.events-connection
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop]])
  (:require
   [taoensso.timbre :refer-macros [debug info]]
   [cljs.core.async :as async :refer [<! >! chan timeout close!]]
   [reagent.core :as r]
   [reagent.ratom :refer [make-reaction]]
   [re-frame.core :refer [reg-event-fx reg-event-db dispatch]]
   [pinkgorilla.nrepl.ws.client :refer [nrepl-client! nrepl-op]]
   [pinkgorilla.nrepl.op.admin :refer [describe ls-sessions]]
   [pinkgorilla.nrepl.op.cider :refer [stacktrace resolve-symbol doc-string completions]]))

(reg-event-db
 :nrepl/init
 (fn [db [_ ws-url]]
   (let [db (or db {})]
     (dispatch [:kernel/register-kernel :clj :nrepl/eval])
     (assoc db :nrepl {:ws-url ws-url
                       :connected? false
                       :conn nil
                       :info {}}))))

(reg-event-db
 :nrepl/set-connection-status
 (fn [db [_ connected?]]
   (info "nrepl-ws: " connected?)
   ;(dispatch  [:nrepl/connection-status-change connected?]) ; better done via raw subscription
   (-> db
       (assoc-in [:nrepl :connected?] connected?))))

(reg-event-db
 :nrepl/connect
 (fn [{:keys [nrepl] :as db} [_]]
   (let [{:keys [ws-url]} nrepl
         {:keys [connected? session-id] :as conn} (nrepl-client! ws-url)]
     #_(go-loop [c 1]
         (<! (timeout 5000))
         (info "xxx connected: " @connected? "session id: " @session-id)
         (recur 5))
     (add-watch connected? :my-watch (fn [c]
                                       (debug "nrepl ws connected? " @connected?)
                                       (dispatch [:nrepl/set-connection-status @connected?])))
     (assoc-in db [:nrepl :conn] conn))))








