(ns pinkgorilla.notebook-ui.notebook.codemirror
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.codemirror.editor :refer [codemirror-reagent]]
   #_[pinkgorilla.notebook-ui.completion.component :refer [completion-component]]))

(defn codemirror-edit [{:keys [id] :as eval-result}]
  (let [settings (subscribe [:settings])]
    (fn [{:keys [id code] :as eval-result}]
      (let [theme (or (:codemirror-theme @settings) "paraiso-dark")
            options-notebook {:theme theme
                              :move-up #(dispatch [:notebook/move :up])
                              :move-down #(dispatch [:notebook/move :down])
                              :save (fn [code type]
                                      (case type
                                        :md (dispatch [:notebook/set-md id code])
                                        :code (dispatch [:notebook/set-code id code])
                                        (dispatch [:notebook/set-code id code])))
                              :eval #(dispatch [:notebook/eval])}]
        ;(info "render codemirror-edit " id code)
        [:div.my-codemirror
         [codemirror-reagent eval-result options-notebook]]))))



