
(ns pinkgorilla.notebook-ui.datafy.events-dialog
  (:require
   [taoensso.timbre :refer-macros [info]]
   [re-frame.core :refer [reg-event-db dispatch dispatch-sync reg-sub]]
   ;[pinkgorilla.ui.ui.dialog :refer [close-modal]]
   [pinkgorilla.notebook-ui.datafy.events-nrepl :refer [decode]]
   [pinkgorilla.notebook-ui.datafy.dialog :refer [datafy-dialog]]))

(reg-event-db
 :punk/set-entries
 (fn [db [_ entries]]
   (assoc-in db [:punk :entries] entries)))

(reg-event-db
 :datafy/show
 (fn [db [_ datafy-str]]
   (let [datafy (when datafy-str
                  (decode datafy-str))
         entries [datafy]]
     (info "showing datafy dialog: " entries)
     (dispatch-sync [:punk/init])
     (dispatch [:punk.ui.browser/view-entry datafy])
     (dispatch [:modal {:show? true
                        :child [datafy-dialog]
                        :size :large}])
     (-> db
         (assoc-in [:punk :entries] entries)))))

(reg-sub
 :datafy/data
 (fn [db _]
   (get-in db [:datafy])))