(ns pinkgorilla.notebook-ui.codemirror.extension
  (:require
   [taoensso.timbre :refer-macros [debug info infof error]]))

(defn run-extension-no-context [{:keys [cm-opts] :as context} [fun-kw & args]]
  (info "running " fun-kw)
  ;(info "cm opts: " cm-opts)
  ;(info "args: " args)
  (if-let [f (fun-kw cm-opts)]
    (apply f args)
    (error "could not find function: " fun-kw)))

(defn run-extension [{:keys [cm-opts] :as context} [fun-kw & args]]
  (info "running codemirror extension: " fun-kw)
  ;(info "cm opts: " cm-opts)
  ;(info "args: " args)
  (if-let [f (fun-kw cm-opts)]
    (if args
      (apply (partial f context) args)
      (f context))
    (error "could not find extension: " fun-kw)))

