(ns pinkgorilla.notebook-ui.notebook.notebook
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [reagent.core :as r]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkgorilla.notebook-ui.notebook.theme :refer [theme-css]]
   [pinkgorilla.notebook-ui.notebook.segment :refer [segment-view]]))

(defn ^{:category :pinkie}
  snippets
  "renders a snippet list"
  [list]
  [:div.w-full.h-full.bg-gray-100
   [theme-css]
   (into [:div] (map segment-view list))])

; use from encoding / hydration

(defn segments-ordered [notebook]
  (let [segments (:segments notebook)
        segment-ids-ordered (:order notebook)]
    (vec (map #(get segments %) segment-ids-ordered))))

(defn code? [segment]
  (= :code (:type segment)))

(defn notebook-viewer [storage notebook]
  (let [segments (segments-ordered notebook)
        settings (subscribe [:settings])
        layout (or (:layout @settings) :vertical)
        segment-active @(subscribe [:notebook/segment-active])
        theme-css-loaded (r/atom false)
        on-css-loaded (fn []
                        (info "notebook viewer css ready!")
                        (reset! theme-css-loaded true))]
    (dispatch [:notebook/activate! storage])
    (when-not (:active notebook)
      (dispatch [:notebook/move :last]))
    (fn [storage notebook]
      [:div.w-full.h-full.min-h-full.bg-gray-100 ; .overflow-scroll
       [theme-css on-css-loaded]
       (if @theme-css-loaded
         (if (= layout :single)
           [segment-view segment-active]
           (into [:div] (map segment-view segments)))
         [:h1 "codemirror theme loading .."])])))

(register-component :p/snippets snippets)