(ns pinkgorilla.notebook-ui.codemirror.theme
  (:require
   [re-frame.core :refer [subscribe]]
   [pinkgorilla.ui.config :refer [#_link-css res-href]]
   [taoensso.timbre :as timbre :refer [debug info warn error]]))

(def theme-names
  ["default" "3024-day" "3024-night" "abcdef" "ambiance" "ayu-dark" "ayu-mirage"
   "base16-dark" "base16-light" "bespin" "blackboard" "cobalt" "colorforth"
   "darcula" "dracula" "duotone-dark" "duotone-light" "eclipse" "elegant"
   "erlang-dark" "gruvbox-dark" "hopscotch" "icecoder" "idea" "isotope"
   "lesser-dark" "liquibyte" "lucario" "material" "material-darker"
   "material-palenight" "material-ocean" "mbo" "mdn-like" "midnight" "monokai"
   "moxer" "neat" "neo" "night" "nord" "oceanic-next" "panda-syntax"
   "paraiso-dark" "paraiso-light" "pastel-on-dark" "railscasts" "rubyblue"
   "seti" "shadowfox" "solarized dark" "solarized light" "the-matrix"
   "tomorrow-night-bright" "tomorrow-night-eighties" "ttcn" "twilight"
   "vibrant-ink" "xq-dark" "xq-light" "yeti" "yonce" "zenburn"])

(def themes (->> theme-names (mapv vector (map keyword theme-names)) (into {})))

; var link = document.createElement ('link');
;link.rel  = 'stylesheet';
;link.href = cssURL;
;document.head.appendChild (link);

;var head  = document.getElementsByTagName('head')[0];
;    var link  = document.createElement('link');
;    link.id   = cssId;
;    link.rel  = 'stylesheet';
;    link.type = 'text/css';
;    link.href = 'http://website.com/css/stylesheet.css';
;    link.media = 'all';
;    head.appendChild(link);


(defn add-theme-css [theme-name]
  (let [href (str "/r/codemirror/theme/" theme-name ".css")
        _ (println "adding: " href)
        head (.-head js/document)
        href (clj->js href)
        link (.createElement js/document "link")]
    (.setAttribute link "href" href)
    (.setAttribute link "rel" "stylesheet")
    (.setAttribute link "type" "text/css")
    (println "link: " href)
    (.appendChild head link)))

;(add-theme-css "paraiso-dark")


(def codemirror-inline
  ; Set height, width, borders, and global font properties here
  ; height: 200px;
  ; height: auto; "400px" "100%"  height: auto;
  [:style
   ".my-codemirror > .CodeMirror { font-family: monospace;
                  height: auto;
            }"])

(def codemirror-fullscreen
  [:div])

(defn link-css [href on-load]
  [:link {:rel "stylesheet"
          :href (res-href href)
          :ref (fn [node]
                 (on-load))}])

(defn theme-codemirror [on-load]
  (let [settings (subscribe [:settings])
        {:keys [codemirror-theme layout]
         :or {codemirror-theme "paraiso-dark"
              layout :vertical}}  @settings
        count (atom 0)
        min-count (if (= codemirror-theme "default")
                    1
                    2)
        on-css-loaded (fn []
                        (info "codemirror css partially loaded!")
                        (swap! count inc)
                        (when (>= @count min-count)
                          (info "codemirror css has loaded!")
                          (when on-load
                            (on-load))))]
    [:div
   ; dynamically loading css will not work the first time
     ; the editor is shown. css might get rendered after codemirror. 
     [link-css "codemirror/lib/codemirror.css" on-css-loaded]

     (when-not (= codemirror-theme "default")
       (info "loading codemirror-theme: " codemirror-theme)
       [link-css (str "codemirror/theme/" codemirror-theme ".css") on-css-loaded])

     (if (= layout :single)
       codemirror-fullscreen
       codemirror-inline)]))

