(ns pinkgorilla.notebook-ui.notebook.codemirror
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.codemirror.editor :refer [codemirror-reagent]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.completion.component :refer [completion-component]]))

(defn codemirror-edit [cm-opts {:keys [id] :as eval-result}]
  (let [settings (subscribe [:settings])
        theme (or (:codemirror-theme @settings) "paraiso-dark")
        buffer (subscribe [:notebook/segment-active])
        options-notebook {:theme theme
                          :move-up #(dispatch [:notebook/move :up])
                          :move-down #(dispatch [:notebook/move :down])
                          :save (fn [code]
                                  (dispatch [:notebook/set-code id code]))
                          :eval #(dispatch [:notebook/eval])}]
    [codemirror-reagent buffer (merge options-notebook cm-opts)]))

(defn codemirror-edit-inline [{:keys [id] :as eval-result}]
  (let [_ (info "codemirror-inline is loading: " id)
        cm-opts {:class "flex.flex-row"
                 :style {:height "auto" ; "400px" "100%" 
                         :width  "100%" ; "400px"
                         :font-size 16
                         :padding "2px"}}]
    [codemirror-edit cm-opts eval-result]))

(defn codemirror-edit-fullscreen [{:keys [id] :as eval-result}]
  (let [_ (info "codemirror-full is loading: " id)
        cm-opts {:height  "100px" ; "100%" ; "auto" (auto=resize-to content) ; "200px"
                 :width  "100%" ; "400px"
                 :font-size 16
                 :padding "2px"
                 :class "flex.flex-row"
                 :style {}}]
    [codemirror-edit cm-opts eval-result]))


; :readOnly (opts :readonly)
