(ns pinkgorilla.notebook-ui.codemirror.theme
  (:require
   [re-frame.core :refer [subscribe]]
   [pinkgorilla.ui.config :refer [link-css]]))

(def theme-names
  ["default" "3024-day" "3024-night" "abcdef" "ambiance" "ayu-dark" "ayu-mirage"
   "base16-dark" "base16-light" "bespin" "blackboard" "cobalt" "colorforth"
   "darcula" "dracula" "duotone-dark" "duotone-light" "eclipse" "elegant"
   "erlang-dark" "gruvbox-dark" "hopscotch" "icecoder" "idea" "isotope"
   "lesser-dark" "liquibyte" "lucario" "material" "material-darker"
   "material-palenight" "material-ocean" "mbo" "mdn-like" "midnight" "monokai"
   "moxer" "neat" "neo" "night" "nord" "oceanic-next" "panda-syntax"
   "paraiso-dark" "paraiso-light" "pastel-on-dark" "railscasts" "rubyblue"
   "seti" "shadowfox" "solarized dark" "solarized light" "the-matrix"
   "tomorrow-night-bright" "tomorrow-night-eighties" "ttcn" "twilight"
   "vibrant-ink" "xq-dark" "xq-light" "yeti" "yonce" "zenburn"])

(def themes (->> theme-names (mapv vector (map keyword theme-names)) (into {})))

; var link = document.createElement ('link');
;link.rel  = 'stylesheet';
;link.href = cssURL;
;document.head.appendChild (link);

;var head  = document.getElementsByTagName('head')[0];
;    var link  = document.createElement('link');
;    link.id   = cssId;
;    link.rel  = 'stylesheet';
;    link.type = 'text/css';
;    link.href = 'http://website.com/css/stylesheet.css';
;    link.media = 'all';
;    head.appendChild(link);


(defn add-theme-css [theme-name]
  (let [href (str "/codemirror/theme/" theme-name ".css")
        _ (println "adding: " href)
        head (.-head js/document)
        href (clj->js href)
        link (.createElement js/document "link")]
    (.setAttribute link "href" href)
    (.setAttribute link "rel" "stylesheet")
    (.setAttribute link "type" "text/css")
    (println "link: " href)
    (.appendChild head link)))

(add-theme-css "paraiso-dark")

(defn theme-codemirror []
  (let [settings (subscribe [:settings])
        theme (or (:codemirror-theme @settings) "paraiso-dark")]
   ; dynamically loading css will not work the first time
     ; the editor is shown. css might get rendered after codemirror. 
    [link-css "codemirror/lib/codemirror.css"]
    [link-css (str "codemirror/theme/" theme ".css")]))

