(ns pinkgorilla.notebook-ui.codemirror.options
  (:require
   [reagent.core :as r]))

(def settings (r/atom
               {:parinfer false
                :vim false
                :warning-as-error false}))

(def cm-default-opts
  {:lineNumbers true
   :firstLineNumber 1
   :lineWrapping true ;  false=scroll (horizontal), true=wrap 
   ; viewportMargin: Specifies the amount of lines that are rendered above and 
   ; below the part of the document that's currently scrolled into view. This 
   ; affects the amount of updates needed when scrolling, and the amount of 
   ; work that such an update does. You should usually leave it at its 
   ; default, 10. Can be set to Infinity to make sure the whole document is 
   ; always rendered, and thus the browser's text search works on it. This 
   ; will have bad effects on performance of big documents.
   ;:viewportMargin js/Infinity
   :matchBrackets true
   :autoCloseBrackets "()[]{}\"\""
   :autofocus true
   :showCursorWhenSelecting true
   :theme "paraiso-dark" ; "default" ; 
   :extraKeys #js {"Shift-Enter" "newlineAndIndent"}
   :mode (if (:parinfer @settings)
           "clojure-parinfer"
           "clojure")
   :keyMap (if (:vim @settings) "vim" "default")})

(def code-mirror-key-down
  [; eval 
   {:key     ::eval
    :spec    "enter"
    :scope :codemirror-no-context
    :handler [:eval]} ; :eval goes to buffer/notebook/eval
   ; buffer navigation
   {:key     ::up
    :spec    "up"
    :scope :codemirror
    :handler [:arrow-up]} ; [:move-up]
   {:key     ::down
    :spec    "down"
    :scope :codemirror
    :handler [:arrow-down]} ; [:move-down]
   ; code completion
   {:key     ::hint
    :desc    "Show possible auto-completions."
    :spec      "ctrl-space"
    :scope    :codemirror
    :handler [:hint]}
   {:key     ::next
    :spec    "tab"
    :scope    :codemirror
    :handler [:hint-next]}
   {:key     ::prior
    :spec     "shift-tab"; "shift-tab"
    :scope    :codemirror
    :handler [:hint-prior]}
   #_{:key     ::showallshow
      :spec    "ctrl" ; ["ctrl" "alt" "select"]  ; (ctrl alt window-left select)
      :scope :global
      :handler [:completion/show-all true]}
   ; test
   {:key     ::test
    :spec    "t"
    :scope :codemirror-no-context
    :handler [:eval]}])

(def code-mirror-key-up
  [#_{:key     ::clear
      :spec    "enter" ;  ["enter"] ; "escape"
      :handler [:completion/clear]}
   #_{:key     ::show-all-hide
      :spec    "ctrl" ; "["ctrl" "alt"] ; #{ctrl alt window-left select} ; "select"
      :scope :global
      :handler [:completion/show-all  false]}])



