(ns pinkgorilla.notebook-ui.notebook.events-segment
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :refer [reg-sub]]
   [pinkgorilla.notebook-ui.notebook.events :refer [current-notebook change-current-notebook]]))

(defn segment-acive [db]
  (let [document (current-notebook db)
        active (:active document)
        segment (when (and document active)
                  (get-in document [:segments active]))]
    segment))

(defn segment-op [db fun]
  (let [document (current-notebook db)
        active (:active document)
        segment (when (and document active)
                  (get-in document [:segments active]))]
    (if segment
      (let [segment-new (fun segment)]
        ;(info "document: " d)
        (change-current-notebook
         db
         (assoc-in document [:segments active] segment-new)))
      (do (error "cannot do segment-op: no active segment!")
          db))))

(reg-sub
 :notebook/segment-active
 (fn [db [_]]
   (segment-acive db)))

#_(reg-sub
   :buffer/sort
   (fn [db [_]]
     (-> db
         (get-in [:buffer :sort]))))



