(ns pinkgorilla.notebook-ui.nrepl.view
  (:require
   [taoensso.timbre :refer-macros [info]]))

(defn v [title version]
  [:p
   [:span.w-16.inline-block title]
   [:span version]])

(defn ops-panel [ops]
  (info "ops:" ops)
  [:div
   [:p.text-large.text-blue-700.text-bold "NRepl Operations"]
   (into [:div.grid.grid-cols-4.gap-1.w-full]
         (map (fn [o] [:p ; {:class "w-1/5"} 
                       o]) ops))])

(defn desc-panel [description]
  (if description
    (let [nrepl-version (get-in description [:versions :nrepl :version-string])
          clj-version (get-in description [:versions :clojure :version-string])
          java-version (get-in description [:versions :java :version-string])
          ops (get-in description [:ops])
          ops-list (keys ops)]
      [:div
       [:p.text-large.text-blue-700.text-bold "NRepl Versions"]
       [v "nREPL" nrepl-version]
       [v "Clojure" clj-version]
       [v "Java" java-version]
       [ops-panel ops-list]
       #_[:p " Results: Stored in vars *1, *2, *3, an exception in *e"]])
    [:div "No desc rcvd!"]))

(defn session-panel [sessions]
  (info "sessions: " sessions)
  (if sessions
    [:div [:p.text-large.text-blue-700.text-bold "NRepl Sessions " (count sessions)]
     (into [:div.grid.grid-cols-4.gap-1.w-full]
           (map (fn [s] [:p ; {:class "w-1/5"} 
                         (str s)]) sessions))]
    [:p.text-large.text-red-700.text-bold "no session data!"]))
