(ns pinkgorilla.notebook-ui.codemirror.options
  (:require
   [reagent.core :as r]))

(def settings (r/atom
               {:parinfer false
                :vim false
                :warning-as-error false}))

(def cm-default-opts
  {:lineNumbers true
    ;:viewportMargin js/Infinity
   :matchBrackets true
   :autofocus true
   :extraKeys #js {"Shift-Enter" "newlineAndIndent"}
   :autoCloseBrackets true
   :mode (if (:parinfer @settings)
           "clojure-parinfer"
           "clojure")
   :keyMap (if (:vim @settings) "vim" "default")
   :showCursorWhenSelecting true})


