(ns pinkgorilla.notebook-ui.codemirror.completion
  (:require
   [re-frame.core :refer [dispatch dispatch-sync subscribe]]
   [cljs.reader]
   [reagent.core :as r]
   [cljs.tools.reader]))

#_(defn cycle-pos
    "Cycle through positions. Returns [active? new-pos].
  count
    total number of completions
  current
    current position
  go-back?
    should we be going in reverse
  initial-active
    if false, then we return not-active when wrapping around"
    [count current go-back? initial-active]
    (if go-back?
      (if (>= 0 current)
        (if initial-active
          [true (dec count)]
          [false 0])
        [true (dec current)])
      (if (>= current (dec count))
        (if initial-active
          [true 0]
          [false 0])
        [true (inc current)])))

#_(defn cycle-completions
    "Cycle through completions, changing the codemirror text accordingly. Returns
  a new state map.
  state
    the current completion state
  go-back?
    whether to cycle in reverse (generally b/c shift is pressed)
  cm
    the codemirror instance
  evt
    the triggering event. it will be `.preventDefault'd if there are completions
    to cycle through."
    [{:keys [num pos active from to list initial-text] :as state}
     go-back? cm evt]
    (when (and state (or (< 1 (count list))
                         (and (< 0 (count list))
                              (not (= initial-text (get (first list) 2))))))
      (.preventDefault evt)
      (let [initial-active (= initial-text (get (first list) 2))
            [active pos] (if active
                           (cycle-pos num pos go-back? initial-active)
                           [true (if go-back? (dec num) pos)])
            text (if active
                   (get (get list pos) 2)
                   initial-text)]
      ;; TODO don't replaceRange here, instead watch the state atom and react to
      ;; that.
        (.replaceRange cm text from to)
        (assoc state
               :pos pos
               :active active
               :to #js {:line (.-line from)
                        :ch (+ (count text)
                               (.-ch from))}))))

(def wordChars
  "[^\\s\\(\\)\\[\\]\\{\\},`']*")

(defn word-in-line
  [line lno cno]
  (let [back (get (.match (.slice line 0 cno) (js/RegExp. (str wordChars "$"))) 0)
        forward (get (.match (.slice line cno) (js/RegExp. (str "^" wordChars))) 0)]
    {:start #js {:line lno
                 :ch (- cno (count back))}
     :end #js {:line lno
               :ch (+ cno (count forward))}}))

(defn cm-current-word
  "Find the current 'word' according to CodeMirror's `wordChars' list"
  [cm]
  (let [pos (.getCursor cm)
        lno (.-line pos)
        cno (.-ch pos)
        line (.getLine cm lno)]
    ;; findWordAt doesn't work w/ clojure-parinfer mode
    ;; (.findWordAt cm back)
    (word-in-line line lno cno)))

(defn repl-hint
  "Get a new completion state."
  [complete-word cm options]
  (println "repl-hint " complete-word cm options)
  (let [range (cm-current-word cm)
        text (.getRange cm
                        (:start range)
                        (:end range))
        words (when (not (empty? text))
                (vec (complete-word text)))]
    (when-not (empty? words)
      {:list words
       :num (count words)
       :active (= (get (first words) 2) text)
       :show-all false
       :initial-text text
       :pos 0
       :from (:start range)
       :to (:end range)})))

(defn complete-word [text]
  (println "code-mirror complete: " text))

(defn cycle-completions [& a]
  (println "cycle completions " a))

(def complete-atom (r/atom []))

(defn completion-cycle [inst evt]
  (swap! complete-atom
         cycle-completions
         (.-shiftKey evt) inst evt)) ; args to cycle-completions

(defn completion-show-one [inst evt]
  (swap! complete-atom assoc :show-all false))

(defn completion-show-all [inst evt]
  (swap! complete-atom assoc :show-all true))

(defn start-completions [inst evt]
  (reset! complete-atom (repl-hint complete-word inst nil)))

(defn remove-completions [inst evt]
  (reset! complete-atom nil))